/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tristatecheckbox;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tristatecheckbox.TriStateCheckbox;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class TriStateCheckboxRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        TriStateCheckbox checkbox = (TriStateCheckbox)component;
        if (checkbox.isDisabled()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)checkbox);
        String clientId = checkbox.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        if (submittedValue != null) {
            checkbox.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        TriStateCheckbox checkbox = (TriStateCheckbox)component;
        this.encodeMarkup(context, checkbox);
        this.encodeScript(context, checkbox);
    }

    protected void encodeMarkup(FacesContext context, TriStateCheckbox checkbox) throws IOException {
        int valCheck;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = checkbox.getClientId(context);
        String valueToRenderer = ComponentUtils.getValueToRender(context, (UIComponent)checkbox);
        int n = valCheck = ComponentUtils.isValueBlank(valueToRenderer) ? 0 : Integer.parseInt(valueToRenderer);
        if (valCheck > 2 || valCheck < 0) {
            valCheck = 0;
        }
        boolean disabled = checkbox.isDisabled();
        String style = checkbox.getStyle();
        String styleClass = checkbox.getStyleClass();
        styleClass = styleClass == null ? "ui-chkbox ui-widget" : "ui-chkbox ui-widget " + styleClass;
        writer.startElement("div", (UIComponent)checkbox);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeInput(context, checkbox, clientId, valCheck, disabled);
        this.encodeOutput(context, checkbox, valCheck, disabled);
        this.encodeItemLabel(context, checkbox);
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, TriStateCheckbox checkbox, String clientId, int valCheck, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        writer.startElement("div", (UIComponent)checkbox);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, "id");
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("value", (Object)valCheck, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (checkbox.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)checkbox.getOnchange(), null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeOutput(FacesContext context, TriStateCheckbox checkbox, int valCheck, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = "ui-chkbox-box ui-widget ui-corner-all ui-state-default";
        styleClass = valCheck == 1 || valCheck == 2 ? styleClass + " ui-state-active" : styleClass;
        styleClass = disabled ? styleClass + " ui-state-disabled" : styleClass;
        String stateOneIconClass = checkbox.getStateOneIcon() != null ? "ui-icon " + checkbox.getStateOneIcon() : "";
        String stateTwoIconClass = checkbox.getStateTwoIcon() != null ? "ui-icon " + checkbox.getStateTwoIcon() : "ui-icon ui-icon-check";
        String stataThreeIconClass = checkbox.getStateThreeIcon() != null ? "ui-icon " + checkbox.getStateThreeIcon() : "ui-icon ui-icon-closethick";
        String statesIconsClasses = "[\"" + stateOneIconClass + "\",\"" + stateTwoIconClass + "\",\"" + stataThreeIconClass + "\"]";
        String stateOneTitle = checkbox.getStateOneTitle() == null ? "" : checkbox.getStateOneTitle();
        String stateTwoTitle = checkbox.getStateTwoTitle() == null ? "" : checkbox.getStateTwoTitle();
        String stateThreeTitle = checkbox.getStateThreeTitle() == null ? "" : checkbox.getStateThreeTitle();
        String statesTitles = "[\"" + stateOneTitle + "\",\"" + stateTwoTitle + "\",\"" + stateThreeTitle + "\"]";
        String iconClass = "ui-chkbox-icon ui-c";
        String activeTitle = "";
        if (valCheck == 0) {
            iconClass = iconClass + " " + stateOneIconClass;
            activeTitle = stateOneTitle;
        } else if (valCheck == 1) {
            iconClass = iconClass + " " + stateTwoIconClass;
            activeTitle = stateTwoTitle;
        } else if (valCheck == 2) {
            iconClass = iconClass + " " + stataThreeIconClass;
            activeTitle = stateThreeTitle;
        }
        String dataTitles = "";
        String titleAtt = "";
        if (!(ComponentUtils.isValueBlank(stateOneTitle) && ComponentUtils.isValueBlank(stateTwoTitle) && ComponentUtils.isValueBlank(stateThreeTitle))) {
            dataTitles = "data-titlestates='" + statesTitles + "' ";
            titleAtt = " title=\"" + activeTitle + "\" ";
        }
        String tabIndexTag = " tabIndex=0 ";
        if (checkbox.getTabindex() != null) {
            tabIndexTag = "tabIndex=" + checkbox.getTabindex() + " ";
        }
        writer.write("<div " + tabIndexTag + titleAtt + "class=\"" + styleClass + "\" data-iconstates='" + statesIconsClasses + "' " + dataTitles + ">" + "<span class=\"" + iconClass + "\"></span></div>");
    }

    protected void encodeItemLabel(FacesContext context, TriStateCheckbox checkbox) throws IOException {
        String label = checkbox.getItemLabel();
        if (label != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-chkbox-label", null);
            writer.writeText((Object)label, "itemLabel");
            writer.endElement("span");
        }
    }

    protected void encodeScript(FacesContext context, TriStateCheckbox checkbox) throws IOException {
        WidgetBuilder wb = RequestContext.getCurrentInstance().getWidgetBuilder();
        wb.initWithDomReady("TriStateCheckbox", checkbox.resolveWidgetVar(), checkbox.getClientId());
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)checkbox);
        wb.finish();
    }
}

