/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.wizard;

import java.io.Serializable;
import javax.el.MethodExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.Widget;
import org.primefaces.component.tabview.Tab;
import org.primefaces.event.FlowEvent;
import org.primefaces.util.ComponentUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Wizard
extends UIComponentBase
implements Widget {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Wizard";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    public static final String DEFAULT_RENDERER = "org.primefaces.component.WizardRenderer";
    public static final String STEP_STATUS_CLASS = "ui-wizard-step-titles ui-helper-reset ui-helper-clearfix";
    public static final String STEP_CLASS = "ui-wizard-step-title ui-state-default ui-corner-all";
    public static final String ACTIVE_STEP_CLASS = "ui-wizard-step-title ui-state-default ui-state-highlight ui-corner-all";
    public static final String BACK_BUTTON_CLASS = "ui-wizard-nav-back";
    public static final String NEXT_BUTTON_CLASS = "ui-wizard-nav-next";
    private Tab current;

    public Wizard() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public String getStep() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.step), null);
    }

    public void setStep(String _step) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.step), (Object)_step);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public MethodExpression getFlowListener() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.flowListener), null);
    }

    public void setFlowListener(MethodExpression _flowListener) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.flowListener), (Object)_flowListener);
    }

    public boolean isShowNavBar() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showNavBar), (Object)true);
    }

    public void setShowNavBar(boolean _showNavBar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showNavBar), (Object)_showNavBar);
    }

    public boolean isShowStepStatus() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showStepStatus), (Object)true);
    }

    public void setShowStepStatus(boolean _showStepStatus) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showStepStatus), (Object)_showStepStatus);
    }

    public String getOnback() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onback), null);
    }

    public void setOnback(String _onback) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onback), (Object)_onback);
    }

    public String getOnnext() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onnext), null);
    }

    public void setOnnext(String _onnext) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onnext), (Object)_onnext);
    }

    public String getNextLabel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.nextLabel), (Object)"Next");
    }

    public void setNextLabel(String _nextLabel) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.nextLabel), (Object)_nextLabel);
    }

    public String getBackLabel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.backLabel), (Object)"Back");
    }

    public void setBackLabel(String _backLabel) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.backLabel), (Object)_backLabel);
    }

    public void processDecodes(FacesContext context) {
        this.decode(context);
        if (!this.isBackRequest(context)) {
            this.getStepToProcess().processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isBackRequest(context)) {
            this.current.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isBackRequest(context)) {
            this.current.processUpdates(context);
        }
    }

    public Tab getStepToProcess() {
        if (this.current == null) {
            String currentStepId = this.getStep();
            for (UIComponent child : this.getChildren()) {
                if (!child.getId().equals(currentStepId)) continue;
                this.current = (Tab)child;
                break;
            }
        }
        return this.current;
    }

    public boolean isWizardRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_wizardRequest");
    }

    public boolean isBackRequest(FacesContext context) {
        return this.isWizardRequest(context) && context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_backRequest");
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof FlowEvent) {
            FlowEvent flowEvent = (FlowEvent)event;
            FacesContext context = this.getFacesContext();
            MethodExpression me = this.getFlowListener();
            if (me != null) {
                String step = (String)me.invoke(context.getELContext(), new Object[]{event});
                this.setStep(step);
            } else {
                this.setStep(flowEvent.getNewStep());
            }
        }
    }

    public String resolveWidgetVar() {
        return ComponentUtils.resolveWidgetVar(this.getFacesContext(), this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKeys {
        widgetVar,
        step,
        style,
        styleClass,
        flowListener,
        showNavBar,
        showStepStatus,
        onback,
        onnext,
        nextLabel,
        backLabel;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

