/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.primefaces.cache.CacheProvider;
import org.primefaces.cache.DefaultCacheProvider;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultApplicationContext
extends ApplicationContext {
    private PrimeConfiguration config;
    private ValidatorFactory validatorFactory;
    private Validator validator;
    private CacheProvider cacheProvider;
    private Map<Class<?>, Map<String, Object>> enumCacheMap;
    private Map<Class<?>, Map<String, Object>> constantsCacheMap;

    public DefaultApplicationContext(FacesContext context) {
        this(context, new PrimeConfiguration(context));
    }

    public DefaultApplicationContext(FacesContext context, PrimeConfiguration config) {
        this.config = config;
        if (this.config.isBeanValidationAvailable()) {
            this.validatorFactory = Validation.buildDefaultValidatorFactory();
            this.validator = this.validatorFactory.getValidator();
        }
        this.enumCacheMap = new ConcurrentHashMap();
        this.constantsCacheMap = new ConcurrentHashMap();
    }

    @Override
    public PrimeConfiguration getConfig() {
        return this.config;
    }

    @Override
    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    @Override
    public CacheProvider getCacheProvider() {
        if (this.cacheProvider == null) {
            this.initCacheProvider();
        }
        return this.cacheProvider;
    }

    protected synchronized void initCacheProvider() {
        if (this.cacheProvider == null) {
            String cacheProviderConfigValue = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("primefaces.CACHE_PROVIDER");
            if (cacheProviderConfigValue == null) {
                this.cacheProvider = new DefaultCacheProvider();
            } else {
                try {
                    this.cacheProvider = (CacheProvider)Class.forName(cacheProviderConfigValue).newInstance();
                }
                catch (ClassNotFoundException ex) {
                    throw new FacesException((Throwable)ex);
                }
                catch (InstantiationException ex) {
                    throw new FacesException((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    throw new FacesException((Throwable)ex);
                }
            }
        }
    }

    @Override
    public Map<Class<?>, Map<String, Object>> getEnumCacheMap() {
        return this.enumCacheMap;
    }

    @Override
    public Map<Class<?>, Map<String, Object>> getConstantsCacheMap() {
        return this.constantsCacheMap;
    }

    @Override
    public Validator getValidator() {
        return this.validator;
    }

    @Override
    public void release() {
        if (this.validatorFactory != null && this.config != null && this.config.isAtLeastBV11()) {
            this.validatorFactory.close();
        }
    }
}

