/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.el;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.faces.el.CompositeComponentExpressionHolder;
import org.primefaces.context.RequestContext;
import org.primefaces.el.InterceptingContext;
import org.primefaces.el.InterceptingResolver;

public class ValueExpressionAnalyzer {
    public static ValueReference getReference(ELContext elContext, ValueExpression expression) {
        ValueExpression unwrapped;
        if (expression == null) {
            return null;
        }
        ValueReference reference = ValueExpressionAnalyzer.toValueReference(expression, elContext);
        if (reference != null && ValueExpressionAnalyzer.isCompositeComponentReference(reference) && (unwrapped = ValueExpressionAnalyzer.unwrapCompositeComponentReference(reference)) != null) {
            ValueReference unwrappedRef = ValueExpressionAnalyzer.toValueReference(unwrapped, elContext);
            if (ValueExpressionAnalyzer.isCompositeComponentReference(unwrappedRef)) {
                return ValueExpressionAnalyzer.getReference(elContext, unwrapped);
            }
            return unwrappedRef;
        }
        return reference;
    }

    public static ValueExpression getExpression(ELContext elContext, ValueExpression expression) {
        ValueExpression unwrapped;
        ValueReference reference;
        if (expression == null) {
            return null;
        }
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isAtLeastEL22() && (reference = ValueExpressionAnalyzer.toValueReference(expression, elContext)) != null && ValueExpressionAnalyzer.isCompositeComponentReference(reference) && (unwrapped = ValueExpressionAnalyzer.unwrapCompositeComponentReference(reference)) != null) {
            if (ValueExpressionAnalyzer.isCompositeComponentReference(ValueExpressionAnalyzer.toValueReference(unwrapped, elContext))) {
                return ValueExpressionAnalyzer.getExpression(elContext, unwrapped);
            }
            return unwrapped;
        }
        return expression;
    }

    public static boolean isCompositeComponentReference(ValueReference vr) {
        return vr != null && vr.getBase() != null && vr.getBase() instanceof CompositeComponentExpressionHolder;
    }

    public static ValueExpression unwrapCompositeComponentReference(ValueReference vr) {
        return ((CompositeComponentExpressionHolder)vr.getBase()).getExpression((String)vr.getProperty());
    }

    public static ValueReference intercept(ELContext elContext, ValueExpression expression) {
        if (expression == null) {
            return null;
        }
        InterceptingResolver resolver = new InterceptingResolver(elContext.getELResolver());
        InterceptingContext interceptingContext = new InterceptingContext(elContext, resolver);
        expression.getType((ELContext)interceptingContext);
        expression.getValue((ELContext)interceptingContext);
        return resolver.getValueReference();
    }

    public static ValueReference toValueReference(ValueExpression ve, ELContext elContext) {
        ValueReference reference = ve.getValueReference(elContext);
        if (reference == null) {
            reference = ValueExpressionAnalyzer.intercept(elContext, ve);
        }
        return reference;
    }
}

