/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression.impl;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.expression.MultiSearchExpressionResolver;
import org.primefaces.expression.SearchExpressionResolver;
import org.primefaces.util.ComponentTraversalUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdExpressionResolver
implements SearchExpressionResolver,
MultiSearchExpressionResolver {
    private static final Pattern PATTERN = Pattern.compile("@id\\(([\\w-]+)\\)");

    @Override
    public UIComponent resolveComponent(FacesContext context, UIComponent source, UIComponent last, String expression, int options) {
        throw new FacesException("@id likely returns multiple components, therefore it's not supported in #resolveComponent... expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
    }

    @Override
    public void resolveComponents(FacesContext context, UIComponent source, UIComponent last, String expression, List<UIComponent> components, int options) {
        ComponentTraversalUtils.withId(this.extractId(expression), last, components);
    }

    protected String extractId(String expression) {
        try {
            Matcher matcher = PATTERN.matcher(expression);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            throw new FacesException("Expression does not match following pattern @id(id). Expression: \"" + expression + "\"");
        }
        catch (Exception e) {
            throw new FacesException("Expression does not match following pattern @id(id). Expression: \"" + expression + "\"", (Throwable)e);
        }
    }
}

