/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.metadata.transformer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.RequestContext;
import org.primefaces.metadata.transformer.MetadataTransformer;
import org.primefaces.metadata.transformer.impl.BeanValidationInputMetadataTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataTransformerExecutor
implements SystemEventListener {
    private static final List<MetadataTransformer> METADATA_TRANSFORMERS = new ArrayList<MetadataTransformer>();
    private static final MetadataTransformer BV_INPUT_METADATA_TRANSFORMER = new BeanValidationInputMetadataTransformer();

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        try {
            if (event instanceof PreRenderComponentEvent) {
                PreRenderComponentEvent preRenderComponentEvent = (PreRenderComponentEvent)event;
                MetadataTransformerExecutor.execute(RequestContext.getCurrentInstance().getApplicationContext().getConfig(), preRenderComponentEvent.getComponent());
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIComponent;
    }

    public static void execute(PrimeConfiguration config, UIComponent component) throws IOException {
        if (config.isTransformMetadataEnabled()) {
            FacesContext context = FacesContext.getCurrentInstance();
            RequestContext requestContext = RequestContext.getCurrentInstance();
            if (config.isBeanValidationAvailable()) {
                BV_INPUT_METADATA_TRANSFORMER.transform(context, requestContext, component);
            }
            if (METADATA_TRANSFORMERS.size() > 0) {
                for (int i = 0; i < METADATA_TRANSFORMERS.size(); ++i) {
                    METADATA_TRANSFORMERS.get(i).transform(context, requestContext, component);
                }
            }
        }
    }

    public static void registerMetadataTransformer(MetadataTransformer metadataTransformer) {
        METADATA_TRANSFORMERS.add(metadataTransformer);
    }

    public static MetadataTransformer removeMetadataTransformer(Class<? extends MetadataTransformer> clazz) {
        Iterator<MetadataTransformer> iterator = METADATA_TRANSFORMERS.iterator();
        while (iterator.hasNext()) {
            MetadataTransformer metadataTransformer = iterator.next();
            if (!metadataTransformer.getClass().equals(clazz)) continue;
            iterator.remove();
            return metadataTransformer;
        }
        return null;
    }
}

