/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.primefaces.component.autocomplete.AutoComplete;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class AutoCompleteRenderer
extends org.primefaces.component.autocomplete.AutoCompleteRenderer {
    protected void encodeScript(FacesContext context, AutoComplete ac) throws IOException {
        String clientId = ac.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("AutoComplete", ac.resolveWidgetVar(), clientId);
        wb.attr("minLength", ac.getMinQueryLength(), 1).attr("delay", ac.getQueryDelay(), 300);
        String emptyMessage = ac.getEmptyMessage();
        if (emptyMessage != null) {
            wb.attr("emptyMessage", emptyMessage, null);
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)ac);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, AutoComplete ac) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ac.getClientId(context);
        String style = ac.getStyle();
        String styleClass = ac.getStyleClass();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        this.encodeInput(context, ac);
        this.encodePanel(context, ac);
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, AutoComplete ac) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ac.getClientId(context);
        String inputId = clientId + "_input";
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)ac);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-input-search ui-body-inherit ui-corner-all ui-shadow-inset ui-input-has-clear", null);
        writer.startElement("input", (UIComponent)ac);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("data-enhanced", (Object)"true", null);
        this.renderPassThruAttributes(context, (UIComponent)ac, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)ac, HTML.INPUT_TEXT_EVENTS);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        if (ac.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (ac.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        writer.endElement("input");
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-input-clear ui-btn ui-icon-delete ui-btn-icon-notext ui-corner-all ui-input-clear-hidden", null);
        writer.endElement("a");
        if (ac.getVar() != null) {
            this.encodeHiddenInput(context, ac, clientId);
        }
        writer.endElement("div");
    }

    protected void encodePanel(FacesContext context, AutoComplete ac) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String panelStyle = ac.getPanelStyle();
        String panelStyleClass = ac.getPanelStyleClass();
        panelStyleClass = panelStyleClass == null ? "ui-controlgroup ui-controlgroup-vertical ui-corner-all ui-screen-hidden" : "ui-controlgroup ui-controlgroup-vertical ui-corner-all ui-screen-hidden " + panelStyleClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)panelStyleClass, null);
        if (panelStyle != null) {
            writer.writeAttribute("style", (Object)panelStyle, null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-controlgroup-controls", null);
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeSuggestions(FacesContext context, AutoComplete ac, List items) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = ac.getVar();
        boolean pojo = var != null;
        Map requestMap = context.getExternalContext().getRequestMap();
        Converter converter = ComponentUtils.getConverter(context, (UIComponent)ac);
        boolean hasContent = ac.getChildCount() > 0;
        for (Object item : items) {
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("class", (Object)"ui-autocomplete-item ui-btn ui-corner-all ui-shadow", null);
            if (pojo) {
                requestMap.put(var, item);
                String value = converter == null ? (String)ac.getItemValue() : converter.getAsString(context, (UIComponent)ac, ac.getItemValue());
                writer.writeAttribute("data-item-value", (Object)value, null);
                writer.writeAttribute("data-item-label", (Object)ac.getItemLabel(), null);
                if (hasContent) {
                    this.renderChildren(context, (UIComponent)ac);
                } else {
                    writer.writeText((Object)ac.getItemLabel(), null);
                }
            } else {
                writer.writeAttribute("data-item-label", item, null);
                writer.writeAttribute("data-item-value", item, null);
                writer.writeText(item, null);
            }
            writer.endElement("a");
        }
        if (pojo) {
            requestMap.remove(var);
        }
    }
}

