/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.inputtextarea.InputTextarea;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class InputTextareaRenderer
extends org.primefaces.component.inputtextarea.InputTextareaRenderer {
    public void encodeMarkup(FacesContext context, InputTextarea inputTextarea) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputTextarea.getClientId(context);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)inputTextarea);
        String style = inputTextarea.getStyle();
        String styleClass = inputTextarea.getStyleClass();
        styleClass = styleClass == null ? "ui-input-text ui-shadow-inset ui-body-inherit ui-corner-all" : "ui-input-text ui-shadow-inset ui-body-inherit ui-corner-all " + styleClass;
        styleClass = !inputTextarea.isDisabled() ? styleClass : styleClass + " ui-state-disabled";
        writer.startElement("textarea", (UIComponent)inputTextarea);
        writer.writeAttribute("data-role", (Object)"none", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        this.renderPassThruAttributes(context, (UIComponent)inputTextarea, HTML.INPUT_TEXTAREA_ATTRS);
        this.renderDomEvents(context, (UIComponent)inputTextarea, HTML.INPUT_TEXT_EVENTS);
        if (inputTextarea.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (inputTextarea.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (valueToRender != null) {
            writer.writeText((Object)valueToRender, "value");
        }
        writer.endElement("textarea");
    }

    public void encodeScript(FacesContext context, InputTextarea inputTextarea) throws IOException {
        String clientId = inputTextarea.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("InputTextarea", inputTextarea.resolveWidgetVar(), clientId).finish();
    }
}

