/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.Menu;
import org.primefaces.mobile.renderkit.BaseMenuRenderer;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.Separator;
import org.primefaces.model.menu.Submenu;
import org.primefaces.util.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuRenderer
extends BaseMenuRenderer {
    @Override
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Menu menu = (Menu)abstractMenu;
        String clientId = menu.getClientId(context);
        String style = menu.getStyle();
        String styleClass = menu.getStyleClass();
        styleClass = styleClass == null ? "ui-menu ui-listview" : "ui-menu ui-listview " + styleClass;
        writer.startElement("ul", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.renderDynamicPassThruAttributes(context, (UIComponent)menu);
        if (menu.getElementsCount() > 0) {
            this.encodeElements(context, menu, menu.getElements());
        }
        writer.endElement("ul");
    }

    protected void encodeSubmenu(FacesContext context, Menu menu, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String label = submenu.getLabel();
        String style = submenu.getStyle();
        String styleClass = submenu.getStyleClass();
        styleClass = styleClass == null ? "ui-li-divider ui-bar-inherit" : "ui-li-divider ui-bar-inherit " + styleClass;
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (label != null) {
            writer.writeText((Object)label, "value");
        }
        writer.endElement("li");
        this.encodeElements(context, menu, submenu.getElements());
    }

    @Override
    protected void encodeSeparator(FacesContext context, Separator separator) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = separator.getStyle();
        String styleClass = separator.getStyleClass();
        styleClass = styleClass == null ? "ui-li-divider ui-bar-inherit" : "ui-li-divider ui-bar-inherit " + styleClass;
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.endElement("li");
    }

    protected void encodeElements(FacesContext context, Menu menu, List<MenuElement> elements) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int elementCount = elements.size();
        for (int i = 0; i < elementCount; ++i) {
            MenuElement element = elements.get(i);
            if (!element.isRendered()) continue;
            if (element instanceof MenuItem) {
                writer.startElement("li", null);
                this.encodeMenuItem(context, menu, (MenuItem)element);
                writer.endElement("li");
                continue;
            }
            if (element instanceof Submenu) {
                this.encodeSubmenu(context, menu, (Submenu)element);
                continue;
            }
            if (!(element instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)element);
        }
    }

    @Override
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        Menu menu = (Menu)abstractMenu;
        String clientId = menu.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("PlainMenu", menu.resolveWidgetVar(), clientId);
        wb.finish();
    }

    @Override
    protected String getLinkStyleClass(MenuItem menuitem) {
        String iconPos;
        String icon = menuitem.getIcon();
        if (icon == null) {
            icon = "ui-icon-carat-r";
        }
        iconPos = (iconPos = menuitem.getIconPos()) == null ? "ui-btn-icon-right" : "ui-btn-icon-" + iconPos;
        String styleClass = "ui-link ui-btn " + icon + " " + iconPos;
        String userStyleClass = menuitem.getStyleClass();
        if (userStyleClass != null) {
            styleClass = styleClass + " " + userStyleClass;
        }
        return styleClass;
    }
}

