/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.panel.Panel;
import org.primefaces.util.WidgetBuilder;

public class PanelRenderer
extends org.primefaces.component.panel.PanelRenderer {
    protected void encodeScript(FacesContext context, Panel panel) throws IOException {
        String clientId = panel.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("Panel", panel.resolveWidgetVar(), clientId);
        wb.attr("toggleable", panel.isToggleable(), false);
        this.encodeClientBehaviors(context, panel);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Panel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = panel.getClientId(context);
        boolean toggleable = panel.isToggleable();
        boolean collapsed = panel.isCollapsed();
        String widgetVar = panel.resolveWidgetVar();
        String style = panel.getStyle();
        String styleClass = panel.getStyleClass();
        String string = styleClass = styleClass == null ? "ui-panel-m ui-corner-all" : "ui-panel-m ui-corner-all " + styleClass;
        if (collapsed) {
            styleClass = styleClass + " ui-hidden-container";
        }
        writer.startElement("div", (UIComponent)panel);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        this.encodeHeader(context, panel, collapsed, toggleable);
        this.encodeContent(context, panel, collapsed);
        this.renderDynamicPassThruAttributes(context, (UIComponent)panel);
        if (toggleable) {
            this.encodeStateHolder(context, panel, clientId + "_collapsed", String.valueOf(collapsed));
        }
        writer.endElement("div");
    }

    protected void encodeHeader(FacesContext context, Panel panel, boolean collapsed, boolean toggleable) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = panel.getFacet("header");
        String headerText = panel.getHeader();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-panel-m-titlebar ui-bar ui-bar-inherit", null);
        writer.startElement("h3", null);
        if (header != null) {
            this.renderChild(context, header);
        } else if (headerText != null) {
            writer.write(headerText);
        }
        writer.endElement("h3");
        if (toggleable) {
            String toggleIconClass = collapsed ? "ui-panel-m-titlebar-icon ui-btn ui-shadow ui-corner-all ui-icon-plus ui-btn-icon-notext ui-btn-right" : "ui-panel-m-titlebar-icon ui-btn ui-shadow ui-corner-all ui-icon-minus ui-btn-icon-notext ui-btn-right";
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("class", (Object)toggleIconClass, null);
            writer.endElement("a");
        }
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, Panel panel, boolean collapsed) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-panel-m-content ui-body ui-body-inherit", null);
        if (collapsed) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        writer.startElement("p", null);
        this.renderChildren(context, (UIComponent)panel);
        writer.endElement("p");
        writer.endElement("div");
    }
}

