/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.password.Password;
import org.primefaces.context.RequestContext;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class PasswordRenderer
extends org.primefaces.component.password.PasswordRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Password password = (Password)component;
        if (password.isDisabled() || password.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)password);
        String inputId = password.getClientId(context) + "_input";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(inputId);
        if (submittedValue != null) {
            password.setSubmittedValue(submittedValue);
        }
    }

    protected void encodeMarkup(FacesContext context, Password password) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = password.getClientId(context);
        boolean disabled = password.isDisabled();
        String inputClass = "ui-input-text ui-body-inherit ui-corner-all ui-shadow-inset ui-input-has-clear";
        inputClass = password.isValid() ? inputClass : inputClass + " ui-state-error";
        inputClass = !disabled ? inputClass : inputClass + " ui-state-disabled";
        String styleClass = password.getStyleClass() == null ? inputClass : inputClass + " " + password.getStyleClass();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (password.getStyle() != null) {
            writer.writeAttribute("style", (Object)password.getStyle(), null);
        }
        this.encodeInput(context, password, clientId);
        this.encodeClearIcon(context, password);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Password password) throws IOException {
        String clientId = password.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("Password", password.resolveWidgetVar(), clientId);
        wb.finish();
    }

    protected void encodeInput(FacesContext context, Password password, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)password);
        String inputId = clientId + "_input";
        writer.startElement("input", (UIComponent)password);
        writer.writeAttribute("data-role", (Object)"none", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"password", null);
        if (password.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (password.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderPassThruAttributes(context, (UIComponent)password, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)password, HTML.INPUT_TEXT_EVENTS);
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isClientSideValidationEnabled()) {
            this.renderValidationMetadata(context, (EditableValueHolder)password);
        }
        writer.endElement("input");
    }

    protected void encodeClearIcon(FacesContext context, Password password) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-input-clear ui-btn ui-icon-delete ui-btn-icon-notext ui-corner-all ui-input-clear-hidden", null);
        writer.endElement("a");
    }
}

