/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tabview.Tab;
import org.primefaces.component.tabview.TabView;
import org.primefaces.util.WidgetBuilder;

public class TabViewRenderer
extends org.primefaces.component.tabview.TabViewRenderer {
    protected void encodeScript(FacesContext context, TabView tabView) throws IOException {
        String clientId = tabView.getClientId(context);
        boolean dynamic = tabView.isDynamic();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("TabView", tabView.resolveWidgetVar(), clientId);
        if (dynamic) {
            wb.attr("dynamic", true).attr("cache", tabView.isCache());
        }
        wb.callback("onTabChange", "function(index)", tabView.getOnTabChange()).callback("onTabShow", "function(index)", tabView.getOnTabShow()).callback("onTabClose", "function(index)", tabView.getOnTabClose());
        this.encodeClientBehaviors(context, tabView);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, TabView tabView) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tabView.getClientId(context);
        String widgetVar = tabView.resolveWidgetVar();
        String style = tabView.getStyle();
        String styleClass = tabView.getStyleClass();
        styleClass = styleClass == null ? "ui-tabs ui-widget ui-widget-content ui-corner-all ui-hidden-container" : "ui-tabs ui-widget ui-widget-content ui-corner-all ui-hidden-container " + styleClass;
        writer.startElement("div", (UIComponent)tabView);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)tabView.getStyle(), "style");
        }
        this.encodeHeaders(context, tabView);
        this.encodeContents(context, tabView);
        this.encodeStateHolder(context, tabView, clientId + "_activeIndex", String.valueOf(tabView.getActiveIndex()));
        this.renderDynamicPassThruAttributes(context, (UIComponent)tabView);
        writer.endElement("div");
    }

    protected void encodeHeaders(FacesContext context, TabView tabView) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int activeIndex = tabView.getActiveIndex();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-navbar", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all", null);
        if (!tabView.isRepeating()) {
            int i = 0;
            for (UIComponent kid : tabView.getChildren()) {
                if (!kid.isRendered() || !(kid instanceof Tab)) continue;
                this.encodeTabHeader(context, tabView, (Tab)kid, i == activeIndex);
                ++i;
            }
        } else {
            int dataCount = tabView.getRowCount();
            activeIndex = activeIndex >= dataCount ? 0 : activeIndex;
            Tab tab = (Tab)((Object)tabView.getChildren().get(0));
            for (int i = 0; i < dataCount; ++i) {
                tabView.setIndex(i);
                this.encodeTabHeader(context, tabView, tab, i == activeIndex);
            }
            tabView.setIndex(-1);
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeTabHeader(FacesContext context, TabView tabView, Tab tab, boolean active) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String headerClass = active ? "ui-tabs-header ui-tabs-active" : "ui-tabs-header";
        String titleClass = active ? "ui-link ui-btn ui-tabs-anchor ui-btn-active" : "ui-link ui-btn ui-tabs-anchor";
        String styleClass = tab.getTitleStyleClass();
        String style = tab.getTitleStyle();
        styleClass = styleClass == null ? headerClass : headerClass + " " + styleClass;
        UIComponent titleFacet = tab.getFacet("title");
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("role", (Object)"tab", null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(active), null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (tab.isDisabled()) {
            titleClass = titleClass + " ui-state-disabled";
        }
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)titleClass, null);
        writer.writeAttribute("href", (Object)("#" + tab.getClientId(context)), null);
        if (titleFacet == null) {
            writer.write(tab.getTitle());
        } else {
            titleFacet.encodeAll(context);
        }
        writer.endElement("a");
        writer.endElement("li");
    }

    protected void encodeContents(FacesContext context, TabView tabView) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int activeIndex = tabView.getActiveIndex();
        boolean dynamic = tabView.isDynamic();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-tabs-panels", null);
        if (!tabView.isRepeating()) {
            int i = 0;
            for (UIComponent kid : tabView.getChildren()) {
                if (!kid.isRendered() || !(kid instanceof Tab)) continue;
                this.encodeTabContent(context, (Tab)kid, i == activeIndex, dynamic);
                ++i;
            }
        } else {
            int dataCount = tabView.getRowCount();
            activeIndex = activeIndex >= dataCount ? 0 : activeIndex;
            Tab tab = (Tab)((Object)tabView.getChildren().get(0));
            for (int i = 0; i < dataCount; ++i) {
                tabView.setIndex(i);
                this.encodeTabContent(context, tab, i == activeIndex, dynamic);
            }
            tabView.setIndex(-1);
        }
        writer.endElement("div");
    }

    protected void encodeTabContent(FacesContext context, Tab tab, boolean active, boolean dynamic) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String visibility = active ? "display:block" : "display:none";
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)tab.getClientId(context), null);
        writer.writeAttribute("style", (Object)visibility, null);
        writer.writeAttribute("role", (Object)"tabpanel", null);
        writer.writeAttribute("aria-hidden", (Object)String.valueOf(!active), null);
        if (dynamic) {
            if (active) {
                tab.encodeAll(context);
                tab.setLoaded(true);
            }
        } else {
            tab.encodeAll(context);
        }
        writer.endElement("div");
    }
}

