/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit.paginator;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.Pageable;
import org.primefaces.component.paginator.PaginatorElementRenderer;

public class PageLinksRenderer
implements PaginatorElementRenderer {
    public void render(FacesContext context, Pageable pageable) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int currentPage = pageable.getPage();
        int pageLinks = pageable.getPageLinks();
        int pageCount = pageable.getPageCount();
        int visiblePages = Math.min(pageLinks, pageCount);
        int start = Math.max(0, (int)Math.ceil(currentPage - visiblePages / 2));
        int end = Math.min(pageCount - 1, start + visiblePages - 1);
        int delta = pageLinks - (end - start + 1);
        for (int i = start = Math.max(0, start - delta); i <= end; ++i) {
            String styleClass = currentPage == i ? "ui-paginator-page ui-btn ui-btn-active" : "ui-paginator-page ui-btn";
            writer.startElement("button", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            writer.writeAttribute("type", (Object)"button", null);
            writer.writeText((Object)(i + 1), null);
            writer.endElement("button");
        }
    }
}

