/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit.paginator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.Pageable;
import org.primefaces.component.api.UIData;
import org.primefaces.component.paginator.PaginatorElementRenderer;
import org.primefaces.mobile.renderkit.paginator.FirstPageLinkRenderer;
import org.primefaces.mobile.renderkit.paginator.LastPageLinkRenderer;
import org.primefaces.mobile.renderkit.paginator.NextPageLinkRenderer;
import org.primefaces.mobile.renderkit.paginator.PageLinksRenderer;
import org.primefaces.mobile.renderkit.paginator.PrevPageLinkRenderer;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class PaginatorRenderer
extends CoreRenderer {
    private static Map<String, PaginatorElementRenderer> ELEMENTS = new HashMap<String, PaginatorElementRenderer>();

    public void encodeMarkup(FacesContext context, Pageable pageable, String position) throws IOException {
        String[] elements;
        if (!pageable.isPaginatorAlwaysVisible() && pageable.getPageCount() <= 1) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String id = pageable.getClientId(context) + "_paginator_" + position;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("class", (Object)"ui-bar-a ui-paginator", null);
        writer.writeAttribute("role", (Object)"navigation", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-controlgroup ui-controlgroup-horizontal ui-corner-all", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-controlgroup-controls", null);
        for (String element : elements = pageable.getPaginatorTemplate().split(" ")) {
            PaginatorElementRenderer renderer = ELEMENTS.get(element);
            if (renderer != null) {
                renderer.render(context, pageable);
                continue;
            }
            UIComponent elementFacet = pageable.getFacet(element);
            if (elementFacet == null) continue;
            elementFacet.encodeAll(context);
        }
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeScript(FacesContext context, UIData uidata, WidgetBuilder wb) throws IOException {
        String clientId = uidata.getClientId(context);
        String paginatorPosition = uidata.getPaginatorPosition();
        String paginatorContainers = null;
        String currentPageTemplate = uidata.getCurrentPageReportTemplate();
        paginatorContainers = paginatorPosition.equalsIgnoreCase("both") ? "'" + clientId + "_paginator_top','" + clientId + "_paginator_bottom'" : "'" + clientId + "_paginator_" + paginatorPosition + "'";
        wb.append(",paginator:{").append("id:[").append(paginatorContainers).append("]").append(",rows:").append(uidata.getRows()).append(",rowCount:").append(uidata.getRowCount()).append(",page:").append(uidata.getPage());
        if (currentPageTemplate != null) {
            wb.append(",currentPageTemplate:'").append(currentPageTemplate).append("'");
        }
        if (uidata.getPageLinks() != 10) {
            wb.append(",pageLinks:").append(uidata.getPageLinks());
        }
        if (!uidata.isPaginatorAlwaysVisible()) {
            wb.append(",alwaysVisible:false");
        }
        wb.append("}");
    }

    static {
        ELEMENTS.put("{FirstPageLink}", new FirstPageLinkRenderer());
        ELEMENTS.put("{PreviousPageLink}", new PrevPageLinkRenderer());
        ELEMENTS.put("{NextPageLink}", new NextPageLinkRenderer());
        ELEMENTS.put("{LastPageLink}", new LastPageLinkRenderer());
        ELEMENTS.put("{PageLinks}", new PageLinksRenderer());
    }
}

