/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.primefaces.model.SortOrder;

public class BeanPropertyComparator
implements Comparator {
    private ValueExpression sortBy;
    private boolean asc;
    private String var;
    private MethodExpression sortFunction;
    private boolean caseSensitive = false;
    private Locale locale;
    private Collator collator;
    private int nullSortOrder;

    public BeanPropertyComparator(ValueExpression sortBy, String var, SortOrder sortOrder, MethodExpression sortFunction, boolean caseSensitive, Locale locale, int nullSortOrder) {
        this.sortBy = sortBy;
        this.var = var;
        this.asc = sortOrder.equals((Object)SortOrder.ASCENDING);
        this.sortFunction = sortFunction;
        this.caseSensitive = caseSensitive;
        this.locale = locale;
        this.collator = Collator.getInstance(locale);
        this.nullSortOrder = nullSortOrder;
    }

    public int compare(Object obj1, Object obj2) {
        try {
            int result;
            FacesContext context = FacesContext.getCurrentInstance();
            context.getExternalContext().getRequestMap().put(this.var, obj1);
            Object value1 = this.sortBy.getValue(context.getELContext());
            context.getExternalContext().getRequestMap().put(this.var, obj2);
            Object value2 = this.sortBy.getValue(context.getELContext());
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null) {
                result = 1 * this.nullSortOrder;
            } else if (value2 == null) {
                result = -1 * this.nullSortOrder;
            } else if (this.sortFunction == null) {
                if (value1 instanceof String && value2 instanceof String) {
                    if (this.caseSensitive) {
                        result = this.collator.compare(value1, value2);
                    } else {
                        String str1 = ((String)value1).toLowerCase(this.locale);
                        String str2 = ((String)value2).toLowerCase(this.locale);
                        result = this.collator.compare(str1, str2);
                    }
                } else {
                    result = ((Comparable)value1).compareTo(value2);
                }
            } else {
                result = (Integer)this.sortFunction.invoke(context.getELContext(), new Object[]{value1, value2});
            }
            return this.asc ? result : -1 * result;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }
}

