/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.chart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.primefaces.model.chart.AxisType;
import org.primefaces.model.chart.CartesianChartModel;
import org.primefaces.model.chart.CategoryAxis;
import org.primefaces.model.chart.ChartSeries;
import org.primefaces.model.chart.LinearAxis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarChartModel
extends CartesianChartModel {
    private int barPadding = 8;
    private int barMargin = 10;
    private int barWidth = 0;
    private boolean stacked = false;

    @Override
    public void createAxes() {
        this.axes = new HashMap();
        this.axes.put(AxisType.X, new CategoryAxis());
        this.axes.put(AxisType.Y, new LinearAxis());
    }

    public String getOrientation() {
        return "vertical";
    }

    public int getBarPadding() {
        return this.barPadding;
    }

    public void setBarPadding(int barPadding) {
        this.barPadding = barPadding;
    }

    public int getBarMargin() {
        return this.barMargin;
    }

    public void setBarMargin(int barMargin) {
        this.barMargin = barMargin;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(int barWidth) {
        this.barWidth = barWidth;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public List<String> getTicks() {
        List<ChartSeries> series = this.getSeries();
        ArrayList<String> ticks = new ArrayList<String>();
        if (series.size() > 0) {
            Map<Object, Number> firstSeriesData = series.get(0).getData();
            for (Object key : firstSeriesData.keySet()) {
                ticks.add(key.toString());
            }
        }
        return ticks;
    }
}

