/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.push.impl;

import java.util.Map;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.FrameworkConfig;
import org.primefaces.push.RemoteEndpoint;
import org.primefaces.push.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteEndpointImpl
implements RemoteEndpoint {
    private final AtmosphereRequest request;
    private final String body;
    private final Status status = new Status(Status.STATUS.OPEN);
    private final String path;
    private final String[] pathSegments;
    private final AtmosphereResource resource;

    public RemoteEndpointImpl(AtmosphereRequest request, String body) {
        this.request = request;
        this.body = body;
        this.path = (String)request.getAttribute(FrameworkConfig.MAPPED_PATH);
        this.pathSegments = this.path.split("/");
        this.resource = request.resource();
    }

    @Override
    public Map<String, String> headersMap() {
        return this.request.headersMap();
    }

    @Override
    public Map<String, String[]> queryStrings() {
        return this.request.queryStringsMap();
    }

    @Override
    public AtmosphereResource.TRANSPORT transport() {
        return this.request.resource().transport();
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String uri() {
        return this.request.getRequestURI();
    }

    @Override
    public String body() {
        return this.body;
    }

    @Override
    public Status status() {
        return this.status;
    }

    @Override
    public String address() {
        return this.request.getRemoteAddr() + ":" + this.request.getRemotePort();
    }

    @Override
    public String pathSegments(int position) {
        if (position < this.pathSegments.length) {
            return this.pathSegments[position];
        }
        return null;
    }

    @Override
    public boolean isOpen() {
        return this.resource.isSuspended();
    }

    public RemoteEndpoint write(String message) {
        this.resource.write(message);
        return this;
    }

    public RemoteEndpoint write(byte[] message) {
        this.resource.write(message);
        return this;
    }

    @Override
    public AtmosphereResource resource() {
        return this.request.resource();
    }

    public String toString() {
        return "RemoteEndpointImpl{request=" + this.request + ", uri='" + this.request.getRequestURI() + '\'' + ", status=" + this.status + '}';
    }
}

