/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.lang.reflect.Array;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.primefaces.renderkit.InputRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectRenderer
extends InputRenderer {
    protected boolean isSelected(FacesContext context, UIComponent component, Object itemValue, Object valueArray, Converter converter) {
        if (itemValue == null && valueArray == null) {
            return true;
        }
        if (valueArray != null) {
            if (!valueArray.getClass().isArray()) {
                return valueArray.equals(itemValue);
            }
            int length = Array.getLength(valueArray);
            for (int i = 0; i < length; ++i) {
                Object compareValue;
                Object value = Array.get(valueArray, i);
                if (value == null && itemValue == null) {
                    return true;
                }
                if (value == null ^ itemValue == null) continue;
                if (converter == null) {
                    compareValue = this.coerceToModelType(context, itemValue, value.getClass());
                } else {
                    compareValue = itemValue;
                    if (compareValue instanceof String && !(value instanceof String)) {
                        compareValue = converter.getAsObject(context, component, (String)compareValue);
                    }
                }
                if (!value.equals(compareValue)) continue;
                return true;
            }
        }
        return false;
    }

    protected int countSelectItems(List<SelectItem> selectItems) {
        if (selectItems == null) {
            return 0;
        }
        int count = selectItems.size();
        for (SelectItem selectItem : selectItems) {
            if (!(selectItem instanceof SelectItemGroup)) continue;
            count += this.countSelectItems(((SelectItemGroup)selectItem).getSelectItems());
        }
        return count;
    }

    protected int countSelectItems(SelectItem[] selectItems) {
        if (selectItems == null) {
            return 0;
        }
        int count = selectItems.length;
        for (SelectItem selectItem : selectItems) {
            if (!(selectItem instanceof SelectItemGroup)) continue;
            count += this.countSelectItems(((SelectItemGroup)selectItem).getSelectItems());
        }
        return count;
    }
}

