/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.beans.BeanInfo;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectTarget;
import javax.faces.view.EditableValueHolderAttachedObjectTarget;

public class CompositeUtils {
    public static boolean isComposite(UIComponent component) {
        return UIComponent.isCompositeComponent((UIComponent)component);
    }

    public static void invokeOnEditableValueHolder(FacesContext context, UIComponent composite, final ContextCallback callback) {
        BeanInfo info = (BeanInfo)composite.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        List targets = (List)info.getBeanDescriptor().getValue("javax.faces.view.AttachedObjectTargets");
        for (AttachedObjectTarget target : targets) {
            if (!(target instanceof EditableValueHolderAttachedObjectTarget)) continue;
            final UIComponent children = composite.findComponent(target.getName());
            if (children == null) {
                throw new FacesException("Cannot find editableValueHolder with name: \"" + target.getName() + "\" in composite component with id: \"" + composite.getClientId() + "\"");
            }
            composite.invokeOnComponent(context, composite.getClientId(context), new ContextCallback(){

                public void invokeContextCallback(FacesContext context, UIComponent target) {
                    if (CompositeUtils.isComposite(children)) {
                        CompositeUtils.invokeOnEditableValueHolder(context, children, callback);
                    } else {
                        callback.invokeContextCallback(context, children);
                    }
                }
            });
        }
    }

    public static void invokeOnDeepestEditableValueHolder(FacesContext context, UIComponent composite, ContextCallback callback) {
        CompositeUtils.invokeOnEditableValueHolder(context, composite, callback);
    }
}

