/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.UUID;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.xml.bind.DatatypeConverter;
import org.primefaces.application.resource.DynamicContentType;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.model.StreamedContent;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LimitedSizeHashMap;
import org.primefaces.util.SharedStringBuilder;

public class DynamicContentSrcBuilder {
    private static final String SB_BUILD = DynamicContentSrcBuilder.class.getName() + "#build";

    public static String build(FacesContext context, Object value, UIComponent component, boolean cache, DynamicContentType type, boolean stream) throws UnsupportedEncodingException {
        String src = null;
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            src = ComponentUtils.getResourceURL(context, (String)value);
        } else if (value instanceof StreamedContent) {
            StreamedContent streamedContent = (StreamedContent)value;
            if (stream) {
                Resource resource = context.getApplication().getResourceHandler().createResource("dynamiccontent.properties", "primefaces", streamedContent.getContentType());
                String resourcePath = resource.getRequestPath();
                Map session = context.getExternalContext().getSessionMap();
                LimitedSizeHashMap<String, String> dynamicResourcesMapping = (LimitedSizeHashMap<String, String>)session.get("primefaces.dynamicResourcesMapping");
                if (dynamicResourcesMapping == null) {
                    dynamicResourcesMapping = new LimitedSizeHashMap<String, String>(200);
                    session.put("primefaces.dynamicResourcesMapping", dynamicResourcesMapping);
                }
                ValueExpression expression = ValueExpressionAnalyzer.getExpression(context.getELContext(), component.getValueExpression("value"));
                String expressionString = expression.getExpressionString();
                String resourceKey = DynamicContentSrcBuilder.md5(expressionString);
                dynamicResourcesMapping.put(resourceKey, expressionString);
                StringBuilder builder = SharedStringBuilder.get(context, SB_BUILD);
                builder.append(resourcePath).append("&").append("pfdrid").append("=").append(URLEncoder.encode(resourceKey, "UTF-8")).append("&").append("pfdrt").append("=").append(type.toString());
                for (UIComponent kid : component.getChildren()) {
                    UIParameter param;
                    if (!(kid instanceof UIParameter) || (param = (UIParameter)kid).isDisable()) continue;
                    Object paramValue = param.getValue();
                    builder.append("&").append(param.getName()).append("=");
                    if (paramValue == null) continue;
                    builder.append(URLEncoder.encode(paramValue.toString(), "UTF-8"));
                }
                src = builder.toString();
            } else {
                byte[] bytes = DynamicContentSrcBuilder.toByteArray(streamedContent.getStream());
                String base64 = DatatypeConverter.printBase64Binary((byte[])bytes);
                return "data:" + streamedContent.getContentType() + ";base64," + base64;
            }
        }
        if (src != null) {
            src = src + (src.contains("?") ? "&" : "?");
            src = src + "pfdrid_c=" + cache;
            if (!cache) {
                src = src + "&uid=" + UUID.randomUUID().toString();
            }
        }
        return context.getExternalContext().encodeResourceURL(src);
    }

    public static byte[] toByteArray(InputStream stream) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = stream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (Exception e) {
            throw new FacesException("Could not read InputStream to byte[]", (Throwable)e);
        }
    }

    private static String md5(String input) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new FacesException((Throwable)ex);
        }
        byte[] bytes = messageDigest.digest(input.getBytes());
        return new BigInteger(1, bytes).toString(16);
    }
}

