/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.WebConfiguration;
import java.util.Map;
import javax.faces.context.FacesContext;

public class FaceletsConfiguration {
    public static final String FACELETS_CONFIGURATION_ATTRIBUTE_NAME = "com.sun.faces.config.FaceletsConfiguration";
    private static final String ESCAPE_INLINE_TEXT_ATTRIBUTE_NAME = "com.sun.faces.config.EscapeInlineText";
    private WebConfiguration config;
    private Map<String, String> faceletsProcessingMappings;

    public FaceletsConfiguration(WebConfiguration config) {
        this.config = config;
        this.faceletsProcessingMappings = config.getFacesConfigOptionValue(WebConfiguration.WebContextInitParameter.FaceletsProcessingFileExtensionProcessAs);
    }

    public boolean isProcessCurrentDocumentAsFaceletsXhtml(String alias) {
        int i;
        boolean currentModeIsXhtml = true;
        String extension = alias;
        if (null == extension) {
            extension = ".xhtml";
        }
        extension = -1 != (i = extension.indexOf(".")) && 1 < extension.length() ? extension.substring(i) : ".xhtml";
        assert (null != this.faceletsProcessingMappings);
        if (this.faceletsProcessingMappings.containsKey(extension)) {
            String value = this.faceletsProcessingMappings.get(extension);
            currentModeIsXhtml = value.equals("xhtml");
        }
        return currentModeIsXhtml;
    }

    public boolean isOutputHtml5Doctype(String alias) {
        int i;
        boolean currentModeIsHtml5 = true;
        String extension = alias;
        if (null == extension) {
            extension = ".xhtml";
        }
        extension = -1 != (i = extension.indexOf(".")) && 1 < extension.length() ? extension.substring(i) : ".xhtml";
        assert (null != this.faceletsProcessingMappings);
        if (this.faceletsProcessingMappings.containsKey(extension)) {
            String value = this.faceletsProcessingMappings.get(extension);
            currentModeIsHtml5 = value.equals("html5");
        }
        return currentModeIsHtml5;
    }

    public boolean isConsumeComments(String alias) {
        int i;
        boolean consumeComments = false;
        String extension = alias;
        if (null == extension) {
            extension = ".xhtml";
        }
        extension = -1 != (i = extension.indexOf(".")) && 1 < extension.length() ? extension.substring(i) : ".xhtml";
        assert (null != this.faceletsProcessingMappings);
        if (this.faceletsProcessingMappings.containsKey(extension)) {
            String value = this.faceletsProcessingMappings.get(extension);
            consumeComments = value.equals("xml") || value.equals("jspx");
        }
        return consumeComments;
    }

    public boolean isConsumeCDATA(String alias) {
        int i;
        boolean consumeCDATA = false;
        String extension = alias;
        if (null == extension) {
            extension = ".xhtml";
        }
        extension = -1 != (i = extension.indexOf(".")) && 1 < extension.length() ? extension.substring(i) : ".xhtml";
        assert (null != this.faceletsProcessingMappings);
        if (this.faceletsProcessingMappings.containsKey(extension)) {
            String value = this.faceletsProcessingMappings.get(extension);
            consumeCDATA = value.equals("jspx") || value.equals("xml");
        }
        return consumeCDATA;
    }

    public boolean isEscapeInlineText(FacesContext context) {
        Boolean result = Boolean.TRUE;
        result = (Boolean)context.getAttributes().get(ESCAPE_INLINE_TEXT_ATTRIBUTE_NAME);
        if (null == result) {
            String value;
            int i;
            String extension = context.getViewRoot().getViewId();
            if (null == extension) {
                extension = ".xhtml";
            }
            extension = -1 != (i = extension.indexOf(".")) && 1 < extension.length() ? extension.substring(i) : ".xhtml";
            assert (null != this.faceletsProcessingMappings);
            result = this.faceletsProcessingMappings.containsKey(extension) ? Boolean.valueOf((value = this.faceletsProcessingMappings.get(extension)).equals("xml") || value.equals("xhtml")) : Boolean.TRUE;
            context.getAttributes().put(ESCAPE_INLINE_TEXT_ATTRIBUTE_NAME, result);
        }
        return result;
    }

    public static FaceletsConfiguration getInstance(FacesContext context) {
        FaceletsConfiguration result = null;
        Map<Object, Object> attrs = context.getAttributes();
        result = (FaceletsConfiguration)attrs.get(FACELETS_CONFIGURATION_ATTRIBUTE_NAME);
        if (null == result) {
            WebConfiguration config = WebConfiguration.getInstance(context.getExternalContext());
            result = config.getFaceletsConfiguration();
            attrs.put(FACELETS_CONFIGURATION_ATTRIBUTE_NAME, result);
        }
        return result;
    }

    public static FaceletsConfiguration getInstance() {
        FacesContext context = FacesContext.getCurrentInstance();
        return FaceletsConfiguration.getInstance(context);
    }
}

