/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.FlowScoped;
import javax.faces.lifecycle.ClientWindow;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowCDIContext
implements Context,
Serializable {
    private static final long serialVersionUID = -7144653402477623609L;
    private transient Map<Contextual<?>, FlowBeanInfo> flowIds;
    private static final FlowScopeMapKey FLOW_SCOPE_MAP_KEY = new FlowScopeMapKey();
    private static final String PER_SESSION_BEAN_MAP_LIST = FlowCDIContext.class.getPackage().getName() + ".PER_SESSION_BEAN_MAP_LIST";
    private static final String PER_SESSION_CREATIONAL_LIST = FlowCDIContext.class.getPackage().getName() + ".PER_SESSION_CREATIONAL_LIST";

    public FlowCDIContext(Map<Contextual<?>, FlowBeanInfo> flowIds) {
        this.flowIds = new ConcurrentHashMap(flowIds);
    }

    private static Map<Contextual<?>, Object> getFlowScopedBeanMapForCurrentFlow() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext extContext = context.getExternalContext();
        Map<String, Object> sessionMap = extContext.getSessionMap();
        Flow currentFlow = FlowCDIContext.getCurrentFlow(context);
        if (null == currentFlow) {
            return null;
        }
        ClientWindow curWindow = context.getExternalContext().getClientWindow();
        if (null == curWindow) {
            throw new IllegalStateException("Unable to obtain current ClientWindow.  Is the ClientWindow feature enabled?");
        }
        String flowBeansForClientWindow = currentFlow.getClientWindowFlowId(curWindow) + "_beans";
        ConcurrentHashMap result = (ConcurrentHashMap)sessionMap.get(flowBeansForClientWindow);
        if (null == result) {
            result = new ConcurrentHashMap();
            sessionMap.put(flowBeansForClientWindow, result);
            FlowCDIContext.ensureBeanMapCleanupOnSessionDestroyed(sessionMap, flowBeansForClientWindow);
        }
        return result;
    }

    private static Map<Contextual<?>, CreationalContext<?>> getFlowScopedCreationalMapForCurrentFlow() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext extContext = context.getExternalContext();
        Map<String, Object> sessionMap = extContext.getSessionMap();
        Flow currentFlow = FlowCDIContext.getCurrentFlow(context);
        ClientWindow curWindow = context.getExternalContext().getClientWindow();
        if (null == curWindow) {
            throw new IllegalStateException("Unable to obtain current ClientWindow.  Is the ClientWindow feature enabled?");
        }
        String creationalForClientWindow = currentFlow.getClientWindowFlowId(curWindow) + "_creational";
        ConcurrentHashMap result = (ConcurrentHashMap)sessionMap.get(creationalForClientWindow);
        if (null == result) {
            result = new ConcurrentHashMap();
            sessionMap.put(creationalForClientWindow, result);
            FlowCDIContext.ensureCreationalCleanupOnSessionDestroyed(sessionMap, creationalForClientWindow);
        }
        return result;
    }

    private static void ensureBeanMapCleanupOnSessionDestroyed(Map<String, Object> sessionMap, String flowBeansForClientWindow) {
        ArrayList<String> beanMapList = (ArrayList<String>)sessionMap.get(PER_SESSION_BEAN_MAP_LIST);
        if (null == beanMapList) {
            beanMapList = new ArrayList<String>();
            sessionMap.put(PER_SESSION_BEAN_MAP_LIST, beanMapList);
        }
        beanMapList.add(flowBeansForClientWindow);
    }

    private static void ensureCreationalCleanupOnSessionDestroyed(Map<String, Object> sessionMap, String creationalForClientWindow) {
        ArrayList<String> beanMapList = (ArrayList<String>)sessionMap.get(PER_SESSION_CREATIONAL_LIST);
        if (null == beanMapList) {
            beanMapList = new ArrayList<String>();
            sessionMap.put(PER_SESSION_CREATIONAL_LIST, beanMapList);
        }
        beanMapList.add(creationalForClientWindow);
    }

    private final void assertNotReleased() {
        if (!this.isActive()) {
            throw new IllegalStateException();
        }
    }

    private Flow getCurrentFlow() {
        Flow result = null;
        FacesContext context = FacesContext.getCurrentInstance();
        result = FlowCDIContext.getCurrentFlow(context);
        return result;
    }

    private static Flow getCurrentFlow(FacesContext context) {
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        if (null == flowHandler) {
            return null;
        }
        Flow result = flowHandler.getCurrentFlow(context);
        return result;
    }

    public static void sessionDestroyed(HttpSessionEvent hse) {
        List creationalList;
        HttpSession session = hse.getSession();
        List beanMapList = (List)session.getAttribute(PER_SESSION_BEAN_MAP_LIST);
        if (null != beanMapList) {
            for (String cur : beanMapList) {
                Map beanMap = (Map)session.getAttribute(cur);
                beanMap.clear();
                session.removeAttribute(cur);
            }
            session.removeAttribute(PER_SESSION_BEAN_MAP_LIST);
            beanMapList.clear();
        }
        if (null != (creationalList = (List)session.getAttribute(PER_SESSION_CREATIONAL_LIST))) {
            for (String cur : creationalList) {
                Map beanMap = (Map)session.getAttribute(cur);
                beanMap.clear();
                session.removeAttribute(cur);
            }
            session.removeAttribute(PER_SESSION_CREATIONAL_LIST);
            creationalList.clear();
        }
    }

    static Map<Object, Object> getCurrentFlowScope() {
        Map<Contextual<?>, Object> flowScopedBeanMap = FlowCDIContext.getFlowScopedBeanMapForCurrentFlow();
        ConcurrentHashMap result = null;
        if (null != flowScopedBeanMap && null == (result = (ConcurrentHashMap)flowScopedBeanMap.get(FLOW_SCOPE_MAP_KEY))) {
            result = new ConcurrentHashMap();
            flowScopedBeanMap.put(FLOW_SCOPE_MAP_KEY, result);
        }
        return result;
    }

    static void flowExited() {
        Map<Contextual<?>, Object> flowScopedBeanMap = FlowCDIContext.getFlowScopedBeanMapForCurrentFlow();
        Map<Contextual<?>, CreationalContext<?>> creationalMap = FlowCDIContext.getFlowScopedCreationalMapForCurrentFlow();
        assert (!flowScopedBeanMap.isEmpty());
        assert (!creationalMap.isEmpty());
        ArrayList flowScopedBeansToRemove = new ArrayList();
        for (Map.Entry<Contextual<?>, Object> entry : flowScopedBeanMap.entrySet()) {
            Contextual<?> owner = entry.getKey();
            Object bean = entry.getValue();
            CreationalContext<?> creational = creationalMap.get(owner);
            owner.destroy(bean, creational);
            flowScopedBeansToRemove.add(owner);
        }
        for (Contextual contextual : flowScopedBeansToRemove) {
            flowScopedBeanMap.remove(contextual);
            creationalMap.remove(contextual);
        }
    }

    static void flowEntered() {
        FlowCDIContext.getFlowScopedBeanMapForCurrentFlow();
        FlowCDIContext.getFlowScopedCreationalMapForCurrentFlow();
        FlowCDIContext.getCurrentFlowScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creational) {
        this.assertNotReleased();
        Object result = this.get(contextual);
        if (null == result) {
            Map<Contextual<?>, Object> flowScopedBeanMap = FlowCDIContext.getFlowScopedBeanMapForCurrentFlow();
            Map<Contextual<?>, CreationalContext<?>> creationalMap = FlowCDIContext.getFlowScopedCreationalMapForCurrentFlow();
            Map<Contextual<?>, Object> map = flowScopedBeanMap;
            synchronized (map) {
                result = flowScopedBeanMap.get(contextual);
                if (null == result) {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
                    if (null == flowHandler) {
                        return null;
                    }
                    FlowBeanInfo fbi = this.flowIds.get(contextual);
                    if (!flowHandler.isActive(facesContext, fbi.definingDocumentId, fbi.id)) {
                        throw new ContextNotActiveException("Request to activate bean in flow '" + fbi + "', but that flow is not active.");
                    }
                    result = contextual.create(creational);
                    if (null != result) {
                        flowScopedBeanMap.put(contextual, result);
                        creationalMap.put(contextual, creational);
                    }
                }
            }
        }
        return result;
    }

    public <T> T get(Contextual<T> contextual) {
        this.assertNotReleased();
        return (T)FlowCDIContext.getFlowScopedBeanMapForCurrentFlow().get(contextual);
    }

    public Class<? extends Annotation> getScope() {
        return FlowScoped.class;
    }

    public boolean isActive() {
        return null != this.getCurrentFlow();
    }

    void beforeShutdown(@Observes BeforeShutdown event, BeanManager beanManager) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FlowScopeMapKey
    implements Contextual<Object> {
        private FlowScopeMapKey() {
        }

        public Object create(CreationalContext<Object> cc) {
            return cc;
        }

        public void destroy(Object t, CreationalContext<Object> cc) {
            Map flowScope = (Map)t;
            flowScope.clear();
        }
    }

    static class FlowBeanInfo {
        String definingDocumentId;
        String id;

        FlowBeanInfo() {
        }
    }
}

