package com.jcg.first.hibernate.example;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;

public class StoreData {

	public static void main(String[] args) {
		// Creating Hibernate Configuration Object 
		Configuration cfgObj = new Configuration();  
		cfgObj.configure("hibernate.cfg.xml");		// Populates The Data Of The Configuration File 

		// Creating Session Factory Object  
		SessionFactory factoryObj = cfgObj.buildSessionFactory();  

		// Creating Session Object  
		Session sessionObj = factoryObj.openSession();  

		//Creating Transaction Object  
		Transaction transObj = sessionObj.beginTransaction();  

		Employee empObj = new Employee();  
		empObj.setId(101);  
		empObj.setFirstName("Java");  
		empObj.setLastName("Geek");  

		sessionObj.persist(empObj);		// Persisting The Object  
		transObj.commit();	// Transaction Is Committed To Database
		sessionObj.close();  

		System.out.println("Employee Data Successfully Saved In Database!"); 
	}
}