package com.jcg.hibernate.many2many.mapping;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;

public class AppMain {

	static Session sessionObj;
	static SessionFactory sessionFactoryObj;

	private static SessionFactory buildSessionFactory() {
		// Creating Configuration Instance & Passing Hibernate Configuration File
		Configuration configObj = new Configuration();
		configObj.configure("hibernate.cfg.xml");

		// Since Hibernate Version 4.x, ServiceRegistry Is Being Used
		ServiceRegistry serviceRegistryObj = new StandardServiceRegistryBuilder().applySettings(configObj.getProperties()).build(); 

		// Creating Hibernate SessionFactory Instance
		sessionFactoryObj = configObj.buildSessionFactory(serviceRegistryObj);
		return sessionFactoryObj;
	}

	public static void main(String[] args) {		
		try {
			sessionObj = buildSessionFactory().openSession();
			sessionObj.beginTransaction();

			Meeting quaterlyMeet = new Meeting("Quaterly Status Meeting");
			Meeting weeklyMeet = new Meeting("Weekly Status Meeting");
			Meeting dailyMeet  = new Meeting("Daily Status Meeting");

			Employee empObj1 = new Employee("Happy", "Potter");
			empObj1.getMeetings().add(quaterlyMeet);
			empObj1.getMeetings().add(weeklyMeet);
			sessionObj.save(empObj1);

			Employee empObj2 = new Employee("Lucifer", "Morningstar");
			empObj2.getMeetings().add(quaterlyMeet);
			sessionObj.save(empObj2);

			Employee empObj3 = new Employee("April O'", "Neil");			
			empObj3.getMeetings().add(weeklyMeet);
			empObj3.getMeetings().add(dailyMeet);
			sessionObj.save(empObj3);

			// Committing The Transactions To The Database
			sessionObj.getTransaction().commit();

			System.out.println("\n.......Records Saved Successfully To The Database.......");
		} catch(Exception sqlException) {
			if(null != sessionObj.getTransaction()) {
				System.out.println("\n.......Transaction Is Being Rolled Back.......");
				sessionObj.getTransaction().rollback();
			}
			sqlException.printStackTrace();
		} finally {
			if(sessionObj != null) {
				sessionObj.close();
			}
		}
	}
}