package com.javacodegeeks.java9.default_gc;

import java.util.HashMap;
import java.util.Map;

public final class Main {

    private static final long INTERVAL = 60000;
    private static final long PAUSE = 10000;

    private Main() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    public static void main(final String... args) {
        final App app = new App(System.currentTimeMillis());
        app.run();
    }

    private static final class App {

        private final Map<Long, Long> pairs;
        private long lastPause;

        private App(long start) {
            this.pairs = new HashMap<>();
            this.lastPause = start;
        }

        private void run() {
            long value = 0;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    final Long item = value;
                    this.pairs.put(item, item);
                    value++;

                    pause();
                    clearItems();
                } catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void clearItems() {
            if (isMemoryLow()) {
                this.pairs.clear();
            }
        }

        private boolean isMemoryLow() {
            long totalMemory = Runtime.getRuntime().totalMemory();
            long freeMemory = Runtime.getRuntime().freeMemory();
            long maxMemory = Runtime.getRuntime().maxMemory();

            long usedMemory = totalMemory - freeMemory;
            long availableMemory = maxMemory - usedMemory;

            return (availableMemory / 1024l) < 10000l;
        }

        private void pause() throws InterruptedException {
            long now = System.currentTimeMillis();
            if (now > (this.lastPause + INTERVAL)) {
                Thread.sleep(PAUSE);
                this.lastPause = now + PAUSE;
            }
        }
    }
}