package com.javacodegeeks.java9.http_client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpResponse;

final class HttpClientSynchronousExamples {

    private HttpClientSynchronousExamples() {
	throw new IllegalStateException("Instantiation not allowed");
    }

    static void start() throws URISyntaxException, IOException, InterruptedException {
	System.out.println("Running synchronous HTTP Client examples\n");

	get();
	post();
	put();
	delete();
    }

    static void get() throws URISyntaxException, IOException, InterruptedException {
	final HttpRequest request = HttpClientHelper.getRequest(HttpClientHelper.CLIENT,
		new URI("https://nghttp2.org/httpbin/get"), HttpClientHelper.HEADERS);
	
	final HttpResponse<String> response = HttpClientHelper.CLIENT.send(request,
		HttpResponse.BodyHandler.asString());

	HttpClientHelper.printResponse(response, "'Get'       : 'https://nghttp2.org/httpbin/get'");
    }

    static void post() throws URISyntaxException, IOException, InterruptedException {
	final HttpRequest request = HttpClientHelper.postRequest(HttpClientHelper.CLIENT,
		new URI("https://nghttp2.org/httpbin/post"), HttpClientHelper.HEADERS,
		() -> HttpRequest.BodyProcessor.fromString("Some data"));

	final HttpResponse<String> response = HttpClientHelper.CLIENT.send(request,
		HttpResponse.BodyHandler.asString());

	HttpClientHelper.printResponse(response, "'Post'      : 'https://nghttp2.org/httpbin/post'");
    }

    static void put() throws URISyntaxException, IOException, InterruptedException {
	final HttpRequest request = HttpClientHelper.putRequest(HttpClientHelper.CLIENT,
		new URI("https://nghttp2.org/httpbin/put"), HttpClientHelper.HEADERS,
		() -> HttpRequest.BodyProcessor.fromString("Some data"));

	final HttpResponse<String> response = HttpClientHelper.CLIENT.send(request,
		HttpResponse.BodyHandler.asString());

	HttpClientHelper.printResponse(response, "'Put'       : 'https://nghttp2.org/httpbin/put'");
    }

    static void delete() throws URISyntaxException, IOException, InterruptedException {
	final HttpRequest request = HttpClientHelper.deleteRequest(HttpClientHelper.CLIENT,
		new URI("https://nghttp2.org/httpbin/delete"), HttpClientHelper.HEADERS,
		() -> HttpRequest.BodyProcessor.fromString("Some data"));

	final HttpResponse<String> response = HttpClientHelper.CLIENT.send(request,
		HttpResponse.BodyHandler.asString());

	HttpClientHelper.printResponse(response, "'Delete'     : 'https://nghttp2.org/httpbin/delete'");
    }
}
