package com.javacodegeeks.java9_regex_example;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Grouping {

    private Grouping() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    static void run() {
        groupByIndex();
        namedGroups();
        backReference();
    }

    private static void groupByIndex() {
        System.out.println("Grouping - simple\n");

        // Interested in 3 groups, groups 1 & 2 must be 2 digits long and separated by a
        // space.
        // Group 3 occurs after a space after group 2 and can be 1 or more digits long
        final Pattern PATTERN = Pattern.compile("^.*(\\d{2}) (\\d{2}) (\\d+)$");
        final Matcher matcher = PATTERN.matcher("+27 99 12345");

        System.out.printf("\tThe number of groups are %d\n\n", matcher.groupCount());

        // Define indexes for the groups in the pattern, first group is always entire
        // input.
        final int countryCodeIdx = 1;
        final int mnoIdx = 2;
        final int numberIdx = 3;

        if (matcher.find()) {

            // Retrieve the group values by the index
            System.out.printf("\tCountry code is %s\n", matcher.group(countryCodeIdx));
            System.out.printf("\tMobile network operator code is %s\n", matcher.group(mnoIdx));
            System.out.printf("\tNumber is %s\n", matcher.group(numberIdx));
        }

        System.out.println("-----\n");
    }

    private static void namedGroups() {
        System.out.println("Grouping - named groups\n");

        // Label the group with a name. Here we are interested in the beverage name that
        // occurs after 'drink ' and the food being eaten after 'eat '.
        final Pattern pattern = Pattern.compile("^.*drink\\s(?<beverage>\\w+).*eat\\s(?<food>\\w+).*$");
        final Matcher matcher = pattern.matcher("i drink soda, play football, run marathon, eat chips and watch TV");

        // There should be two groups
        System.out.printf("\tThe number of groups are %d\n\n", matcher.groupCount());

        if (matcher.find()) {
            // Reference the group by the label we used.
            System.out.printf("\tThe beverage start index is %d\n", matcher.start("beverage"));
            System.out.printf("\tI drink %s\n", matcher.group("beverage"));
            System.out.printf("\tThe beverage end index is %d\n\n", matcher.end("beverage"));

            // Reference the group by the label we used.
            System.out.printf("\tThe food start index is %d\n", matcher.start("food"));
            System.out.printf("\tI eat %s\n", matcher.group("food"));
            System.out.printf("\tThe food start index is %d\n", matcher.end("food"));
        }

        System.out.println("-----\n");
    }

    private static void backReference() {
        System.out.println("Grouping - back reference\n");

        // We use a back reference by referring to the previous group captured inline in
        // the expression.
        // Group one captures the word after 'of ' and then refers to it in group 2
        // '(\\1)'
        final Pattern pattern = Pattern.compile("^.*of\\s(\\w+).*(\\1).*$");
        final Matcher matcher = pattern.matcher("99 bottles of beer on the wall, if one bottle should fall, 98 bottles of beer on the wall");

        // There should be 2 groups
        System.out.printf("\tThe number of groups are %d\n\n", matcher.groupCount());

        if (matcher.find()) {

            // Select the captured values by group index
            System.out.printf("\tThe are 99 bottles of %s\n", matcher.group(1));
            System.out.printf("\tAfter one fell there are 98 bottles of %s\n", matcher.group(2));
        }

        System.out.println("-----\n");
    }
}
