package com.javacodegeeks.java9_regex_example;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PatternFlags {

    private PatternFlags() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    static void run() {
        cannonicalEQ();
        nonCannonicalEQ();
        caseInsensitive();
        comments();
        paragraph();
        noParagraph();
        literal();
        multiline();
    }

    private static void cannonicalEQ() {
        System.out.println("PatternFlags - cannonical EQ\n");

        // http://www.fileformat.info/info/unicode/char/30A/index.htm
        final String input = "a\u030A";
        // http://www.fileformat.info/info/unicode/char/00E5/index.htm
        final Pattern pattern = Pattern.compile("\u00E5", Pattern.CANON_EQ);

        final Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            System.out.printf("\t %s\n", matcher.group());

            if (matcher.end() < matcher.regionEnd()) {
                System.out.println("");
            }
        }

        System.out.println("-----\n");
    }

    private static void nonCannonicalEQ() {
        System.out.println("PatternFlags - non cannonical EQ\n");

        // http://www.fileformat.info/info/unicode/char/30A/index.htm
        final String input = "a\u030A";
        // http://www.fileformat.info/info/unicode/char/00E5/index.htm
        final Pattern pattern = Pattern.compile("\u00E5");

        final Matcher matcher = pattern.matcher(input);
        boolean result = matcher.find();
        if (!result) {
            System.out.println("\tBecase cannonical equaivelance was not specified this will be false");
        }

        System.out.println("-----\n");
    }

    private static void caseInsensitive() {
        System.out.println("PatternFlags - case insensitive\n");

        final String input = "java";
        final Pattern pattern = Pattern.compile("JAVA", Pattern.CASE_INSENSITIVE);

        final Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            System.out.printf("\t %s\n", matcher.group());

            if (matcher.end() < matcher.regionEnd()) {
                System.out.println("");
            }
        }

        System.out.println("-----\n");
    }

    private static void comments() {
        System.out.println("PatternFlags - comments\n");

        final String input = "bow flow row now snow crow mow vow";

        // The comment is ignored '#....'
        final Pattern pattern = Pattern.compile("(\\b[bn]ow)\\b #I only want to whole words starting with either 'b' or n and ending in 'ow'",
                Pattern.COMMENTS);

        final Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            System.out.printf("\t %s\n", matcher.group());

            if (matcher.end() < matcher.regionEnd()) {
                System.out.println("");
            }
        }

        System.out.println("-----\n");
    }

    private static void paragraph() {
        System.out.println("PatternFlags - paragraph\n");

        final String input = "I was there\nI was also here.";

        // We force the '.' character to include line breaks
        final Pattern pattern = Pattern.compile(".*", Pattern.DOTALL);

        printResults(pattern.matcher(input), input, pattern.pattern());
        System.out.println("-----\n");
    }

    private static void noParagraph() {
        System.out.println("PatternFlags - no paragraph\n");

        final String input = "I was there\nI was also here.";

        // The default behavior of '.' is to ignore line breaks
        final Pattern pattern = Pattern.compile(".*");

        printResults(pattern.matcher(input), input, pattern.pattern());
        System.out.println("-----\n");
    }

    private static void literal() {
        System.out.println("PatternFlags - literally\n");

        final String input = "I was there\nI was also here.";

        // We remove the super powers that are normally given to the '.' character
        final Pattern pattern = Pattern.compile(".*", Pattern.LITERAL);

        final Matcher matcher = pattern.matcher(input);

        System.out.printf("\tInput is %s\n", input);
        System.out.printf("\tRegex is %s\n\n", pattern.pattern());
        System.out.printf("\t %s\n", matcher.find() ? "Whoa!!! This cannot be" : "I expected to find nothing");

        System.out.println("-----\n");
    }

    private static void multiline() {
        System.out.println("PatternFlags - multiline\n");

        final String input = "I was there\nI was also here.";

        // We force the '^' and in particular the '$' character to now see a line feed
        // as the end of a sequence.
        final Pattern pattern = Pattern.compile("^.*there$", Pattern.MULTILINE);

        printResults(pattern.matcher(input), input, pattern.pattern());
        System.out.println("-----\n");
    }

    private static void printResults(final Matcher matcher, final String input, final String regex) {
        System.out.printf("\tInput is %s\n", input);
        System.out.printf("\tRegex is %s\n\n", regex);

        if (matcher.find()) {
            System.out.printf("\t %s\n", matcher.group(0));
        }
    }
}
