package com.javacodegeeks.java9_regex_example;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Quantifiers {

    private Quantifiers() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    static void run() {
        // Consume entire text input and attempt match. If match found, we stop
        // and entire text is returned,
        // if not, we remove one character(s) from right hand side and attempt
        // match with removed character(s),
        // once found, entire text returned, if not found, nothing returned.
        runInternal("ssxx", "Quantifiers greedy - %s\n", "x*");
        runInternal("ssxx", "Quantifiers greedy - %s\n", "x?");
        runInternal("ssxx", "Quantifiers greedy - %s\n", "x+");

        // Consume text one character at a time from left hand side reluctantly
        // and attempt match, if found,
        // return the portion of text from the start of the left hand side up
        // until index of where match finally
        // occurred and then continue until end of input is reached.
        runInternal("xxbx", "Quantifiers reluctant - %s\n", "x*?b");
        runInternal("xxbx", "Quantifiers reluctant - %s\n", "x??b");
        runInternal("xxbx", "Quantifiers reluctant - %s\n", "x+?b");

        // Behaves the same as greedy quantifiers without back off behavior.
        runInternal("xxbx", "Quantifiers possesive - %s\n", "x*+b");
        runInternal("xxbx", "Quantifiers possesive - %s\n", "x?+b");
        runInternal("xxbx", "Quantifiers possesive - %s\n", "x++b");
    }

    private static void runInternal(final String input, final String message, final String regex) {
        System.out.printf(message, input);

        final Pattern pattern = Pattern.compile(regex);
        final Matcher matcher = pattern.matcher(input);

        printResults(matcher, input, pattern.pattern());
        System.out.println("-----\n");
    }

    private static void printResults(final Matcher matcher, final String input, final String regex) {
        System.out.printf("\tInput is %s\n", input);
        System.out.printf("\tRegex is %s\n\n", regex);

        while (matcher.find()) {

            System.out.printf("\tStart index of match %d\n", matcher.start());
            System.out.printf("\tEnd index of match %d\n", matcher.end());
            System.out.printf("\tValue is %s\n", matcher.group());

            if (matcher.end() <= matcher.regionEnd()) {
                System.out.println("");
            }
        }
    }
}
