package com.jcg.java.nio;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class AppendToFile {

	// File Location
	private static String filePath ="config/sample.txt";

	// Content To Be Appended To The Existing File
	private static String contentToAppend = "\nThis Line Was Added At The End Of The File!";

	public static void main(String[] args) {

		// Checking If The File Exists At The Specified Location Or Not
		Path filePathObj = Paths.get(filePath);
		boolean fileExists = Files.exists(filePathObj);
		if(fileExists) {
			try {
				// Appending The New Data To The Existing File
				Files.write(filePathObj, contentToAppend.getBytes(), StandardOpenOption.APPEND);
				System.out.println("! Data Successfully Appended !");
			} catch (IOException ioExceptionObj) {
				System.out.println("Problem Occured While Writing To The File= " + ioExceptionObj.getMessage());
			}
		} else {
			System.out.println("File Not Present! Please Check!");
		}		
	}
}