package com.jcg.spring.mvc.request.mapping;

import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MyController {

	// Handles GET or POST Request
	@RequestMapping("/one")
	public @ResponseBody String handlerOne() {
		return "<h1>Inside handlerOne() Method Of MyController</h1>";
	}

	// Handles POST Request Only
	@RequestMapping(value = "/two", method = RequestMethod.POST)
	public @ResponseBody String handlerTwo() {
		return "<h1>Inside handlerTwo() Method Of MyController</h1>";
	}

	// Handles GET Request Only
	@RequestMapping(value = "/three", method = RequestMethod.GET)
	public @ResponseBody String handlerThree() {
		return "<h1>Inside handlerThree() Method Of MyController</h1>";
	}

	// Handles POST Request If The Request Header Contains 'content-type=application/x-www-form-urlencoded'
	@RequestMapping(value = "/four", method = RequestMethod.POST, headers = {"content-type=application/x-www-form-urlencoded"})
	public @ResponseBody String handlerFour() {
		return "<h1>Inside handlerFour() Method Of MyController</h1>";
	}

	// Handles POST Request If The Request Content Type Iis 'application/x-www-form-urlencoded'
	@RequestMapping(value = "/five", method = RequestMethod.POST, consumes = {MediaType.APPLICATION_FORM_URLENCODED_VALUE})
	public @ResponseBody String handlerFive() {
		return "<h1>Inside handlerFive() Method Of MyController</h1>";
	}

	// Handles POST or GET Request And Produce Content Type Of "text/plain"
	@RequestMapping(value = "/six", produces = {MediaType.TEXT_PLAIN_VALUE})
	public @ResponseBody String handlerSix() {
		return "<h1>Inside handlerSix() Method Of MyController</h1>";
	}
}