package com.jcg.java.nio;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileChannel.MapMode;

public class BufferOverflowException {

	public static void main(String[] args) {

		// Sample Code To Analyse The BufferOverflow Exception
		File sampleFile = new File("config/sample.txt");
		try (RandomAccessFile raf = new RandomAccessFile(sampleFile, "rw")) {
			FileChannel fileChannel = raf.getChannel();
			MappedByteBuffer buf = fileChannel.map(MapMode.READ_WRITE, 0, sampleFile.length());

			final byte[] src = new byte[1000];
			System.out.println(src.length > sampleFile.length());
			buf.put(src);
		} catch (IOException ioException) {
			ioException.printStackTrace();
		}
	}
}