package com.jcg.java.nio;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class FromByteBufferToString {

	public static void main(String[] args) {

		// Allocate A New Non-Direct Bytebuffer With A 100 Byte Capacity & Set This To A Big Value Avoid The 'BufferOverflowException'.
		ByteBuffer buf = ByteBuffer.allocate(100);

		// Creates A View Of This Byte Buffer As A Char Buffer.
		CharBuffer cbuf = buf.asCharBuffer();

		// Write A String To Char Buffer.
		cbuf.put("Hello Java Code Geek!");

		// Flips This Buffer. The Limit Is Set To The Current Position And Then The Position Is Set To Zero. If The Mark Is Defined Then It Is Discarded.
		cbuf.flip();

		String str = cbuf.toString();
		System.out.println(str);
	}
}