package com.jcg.java.nio;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileDeleteExample {

	private static String file_path = "config/sample.txt";

	// STEP #1 - File Exists - This Method Will Delete The File From The Configured Path.
	private static void fileExists() {
		Path filePath = Paths.get(file_path);
		System.out.println("STEP #1" + "\n\n" +"File Exists Before Delete?= " + Files.exists(filePath));
		try {
			System.out.println("! Deleting File From The Configured Path !");
			Files.delete(filePath);
		} catch(IOException ioException) {
			ioException.printStackTrace();
		}
		System.out.println("File Exists After Delete?= " + Files.exists(filePath));
	}

	// STEP #2 - File Doesn't Exists - This Method Will Throw The 'NoSuchFileException'.
	private static void fileDoesnotExists() {
		System.out.println("\n" + "STEP #2" + "\n");
		Path filePath = Paths.get(file_path);
		try {
			Files.delete(filePath);
		} catch (IOException ioException) {
			System.out.println("! Error Caught In Deleting File As The File Is Not Present !");
			ioException.printStackTrace();
		}
	}

	public static void main(String[] args) {
		fileExists();		
		fileDoesnotExists();
	}
}