package com.jcg.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet("/getParameters")
public class ServletUrlParameterExample extends HttpServlet {

	private static final long serialVersionUID = 1L;

	// This Method Is Called By The Servlet Container To Process A 'GET' Request.
	public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
		handleRequest(req, resp);
	}

	public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {

		resp.setContentType("text/html");

		// Get Parameters From The Request
		String param1 = req.getParameter("param1");
		String param2 = req.getParameter("param2");
		String[] paramArray = req.getParameterValues("paramArray");

		if(param1 == null || param2 == null || paramArray == null) {
			// The Request Parameters Were Not Present In The Query String. Do Something Or Exception Handling !!
		} else if ("".equals(param1) || "".equals(param2) || "".equals(paramArray)) {
			// The Request Parameters Were Present In The Query String But Has No Value. Do Something Or  Exception Handling !!
		} else {
			System.out.println("Parameter1?= " + param1 + ", Parameter2?= " + param2 + ", Array Parameters?= " + Arrays.toString(paramArray));

			// Print The Response
			PrintWriter out = resp.getWriter();
			out.write("<html><body><div id='serlvetResponse'>");
			out.write("<h2>Servlet HTTP Request Parameters Example</h2>");
			out.write("<p>param1: " + param1 + "</p>");
			out.write("<p>param2: " + param2 + "</p>");
			out.write("<p>paramArray: " + Arrays.toString(paramArray) + "</p>");
			out.write("</div></body></html>");
			out.close();
		}
	}
}