package com.jcg.servlet;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet("/loginServlet")
public class Login extends HttpServlet {

	private static final long serialVersionUID = 1L;

	// This Method Is Called By The Servlet Container To Process A 'POST' Request.
	public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
		handleRequest(req, resp);
	}

	public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {

		resp.setContentType("text/html");

		// Post Parameters From The Request
		String param1 = req.getParameter("username");
		String param2 = req.getParameter("password");

		// Print The Response
		PrintWriter out = resp.getWriter();
		out.write("<html><body><div id='serlvetResponse' style='text-align: center;'>");

		// Creating The 'RequestDispatcher' Object For Forwading The HTTP Request
		RequestDispatcher rdObj = null;

		// Checking For Null & Empty Values
		if(param1 == null || param2 == null || "".equals(param1) || "".equals(param2)) {
			out.write("<p id='errMsg' style='color: red; font-size: larger;'>Please Enter Both Username & Password... !</p>");
			rdObj = req.getRequestDispatcher("/index.jsp");
			rdObj.include(req, resp);
		} else {
			System.out.println("Username?= " + param1 + ", Password?= " + param2);

			// Authentication Logic & Building The Html Response Code
			if((param1.equalsIgnoreCase("jcg")) && (param2.equals("admin@123"))) {
				rdObj = req.getRequestDispatcher("/welcomeServlet");
				rdObj.forward(req, resp);					
			} else {
				out.write("<p id='errMsg' style='color: red; font-size: larger;'>You are not an authorised user! Please check with administrator!</p>");
				rdObj = req.getRequestDispatcher("/index.jsp");
				rdObj.include(req, resp);
			}			
		}
		out.write("</div></body></html>");
		out.close();
	}
}