package com.httpunitsample.controllertest;

import static org.hamcrest.CoreMatchers.containsString;
import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertThat;

import java.io.IOException;
import java.util.Arrays;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.junit4.SpringRunner;
import org.xml.sax.SAXException;

import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebResponse;

@RunWith(SpringRunner.class) 
public class RegistrationControllerTest {

		@Test
		public void registrationTest() throws IOException, SAXException {
			 WebConversation wc = new WebConversation();
			 WebResponse   resp = wc.getResponse( "http://localhost:8080/registrationForm" );
			 WebForm form = resp.getForms()[0];
			 assertEquals( "", form.getParameterValue( "name" ) );
			 assertEquals( "Dont want to say", form.getParameterValue( "gender" ) );
			 assertArrayEquals( new String[] {"America","India"},   form.getOptionValues( "countryId" ));
		}
		
		@Test
		public void registerUserTest() throws IOException, SAXException {
			 WebConversation wc = new WebConversation();
			 WebResponse   resp = wc.getResponse( "http://localhost:8080/registrationForm" );
			 WebForm form = resp.getForms()[0];
			 form.setParameter("name", "Gaurav" );
			 form.setParameter("gender", "Male");
			 form.setParameter("countryId", "India");
			 WebResponse response=form.submit();
			 assertThat(response.getText(),containsString("Thank you for registration "));
		}
		
}



