package com.jcg.servlet.async;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(urlPatterns = "/AsyncContextDispatch", asyncSupported = true)
public class AsyncContextDispatch extends HttpServlet {

	private static final long serialVersionUID = 1L;

	public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		doGet(req, resp);
	}

	public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {

		Date dateObj = new Date();

		resp.setContentType("text/html");
		PrintWriter out = resp.getWriter();
		out.print("<h2>AsyncContext Example </h2>");

		req.setAttribute("receivedAt", dateObj);
		out.println("Request Time?= " + req.getAttribute("receivedAt"));

		AsyncContext asyncCtx = req.startAsync();
		ServletRequest servReq = asyncCtx.getRequest();

		boolean isAsyncStarted = servReq.isAsyncStarted();
		// This Will Return True
		out.println("<br>AsyncStarted?= " + isAsyncStarted);
		if (isAsyncStarted) {
			asyncCtx.dispatch("/asyncOutput.jsp");
		}

		boolean isAsyncSupported = req.isAsyncSupported();
		// This Will Return True
		out.println("<br>AsyncSupported?= " + isAsyncSupported);
	}
}