package com.jcg.java;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.format.DateTimeFormatter;

/**
 * Java Program to demonstrate How to use LocalDateTime class in Java8. 
 * LocalDateTime is LocalDate + LocalTime, i.e. date with time
 * */
public class LocalDateTimeDemo {

	public static void main(String[] args) {

		/**** LocalDate is Date Without Time in Java8 ****/
		/**** LocalTime is Time Without Date in Java8 ****/
		/**** LocalDateTime is both Date and Time e.g. LocalDate + LocalTime but without TimeZone information ****/

		/**** EXAMPLE #1 ****/
		/**** LocalDateTime.now() creates a LocalDateTieme object with Current Date and Time ****/
		LocalDateTime rightNow = LocalDateTime.now();
		System.out.println("Current DateTime?= " + rightNow + "\n");

		/**** Formatting the Date using ISO_LOCAL_DATE ****/
		String isoDate = rightNow.format(DateTimeFormatter.ISO_LOCAL_DATE);
		System.out.println("ISO Formatted Date?= " + isoDate + "\n");

		/**** Formatting the Date using PATTERN ****/
		String pattern = "dd-MMM-yyyy HH:mm:ss";
		String patternDate = rightNow.format(DateTimeFormatter.ofPattern(pattern));
		System.out.println("Pattern Formatted DateTime?= " + patternDate + "\n");

		/**** EXAMPLE #2 ****/
		/**** LocalDateTime.of() method is a factory method to create LocalDateTiem with Specific Date and Time ****/
		LocalDateTime sDateTime = LocalDateTime.of(2017, Month.DECEMBER, 22, 21, 30, 40); 
		System.out.println("Some DateTime?= " + sDateTime + "\n");

		/**** EXAMPLE #3 ****/
		/**** Developers can also create LocalDateTime object by combining LocalDate and LocalTime ****/
		LocalDate currentDate = LocalDate.now(); 
		LocalTime currentTime = LocalTime.now(); 
		LocalDateTime fromDateAndTime = LocalDateTime.of(currentDate, currentTime); 
		System.out.println("LocalDateTime created by combining 'LocalDate' and 'LocalTime'?= " + fromDateAndTime + "\n");

		/**** EXAMPLE #4 ****/
		/**** Developers can also retrieve LocalDate and LocalTime from LocalDateTime ****/
		LocalDate retrievedDate = fromDateAndTime.toLocalDate(); 
		LocalTime retrievedTime = fromDateAndTime.toLocalTime(); 
		System.out.println("Retrieved LocalDate?= " + retrievedDate + ", Retrieved LocalTime?= " + retrievedTime);		
	}
}