package com.jcg.java.mongodb;

import org.apache.log4j.Logger;
import org.bson.Document;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;

public class MongoDemo {

	private static Logger log = Logger.getLogger(MongoDemo.class);

	// Performing a read operation on the collection.
	private static void getAllDocuments(MongoCollection<Document> col) {		
		FindIterable<Document> fi = col.find();
		MongoCursor<Document> cursor = fi.iterator();
		try {
			while(cursor.hasNext()) {
				log.info(cursor.next().toJson());
			}
			log.info("\n");
		} finally {
			cursor.close();
		}
	}

	@SuppressWarnings("resource")
	public static void main(String[] args) {

		// Mongodb initialization parameters.
		int port_no = 27017;
		UpdateResult result = null;
		String host_name = "localhost", db_name = "sampledb", db_coll_name = "emp";

		// Mongodb connection string.
		String client_url = "mongodb://" + host_name + ":" + port_no + "/" + db_name;
		MongoClientURI uri = new MongoClientURI(client_url);

		// Connecting to the mongodb server using the given client uri.
		MongoClient mongo_client = new MongoClient(uri);

		// Fetching the database from the mongodb.
		MongoDatabase db = mongo_client.getDatabase(db_name);

		// Fetching the collection from the mongodb.
		MongoCollection<Document> coll = db.getCollection(db_coll_name);

		// Fetching documents from the mongodb.
		log.info("Fetching existing documents from the collection");
		getAllDocuments(coll);

		// Updating a single document that matches a condition.
		int newAge = 31;
		result = coll.updateOne(Filters.eq("unit_tag_code", "payroll_1064"), new Document("$set", new Document("age", newAge)));
		log.info("Records updated?= " + result.getModifiedCount() + "\n");

		// Fetching documents from the mongodb.
		log.info("[UPDATE] Fetching all documents after updating a single record");
		getAllDocuments(coll);

		// Updating multiple documents that matches a condition.
		int incVal = 5;
		result = coll.updateMany(Filters.eq("unit_tag_code", "hr_1002"), new Document("$inc", new Document("age", incVal)));
		log.info("Records updated?= " + result.getModifiedCount() + "\n");

		// Fetching documents from the mongodb.
		log.info("[UPDATE] Fetching all documents after updating a multiple  record");
		getAllDocuments(coll);
	}
}