package com.jcg.spring.hibernate.ctrl;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import com.jcg.spring.hibernate.pojo.User;
import com.jcg.spring.hibernate.service.DbService;

@Controller
public class UserCtrl {

	@Autowired
	private DbService dbService;			// This will auto-inject the authentication service into the controller.

	private static Logger log = Logger.getLogger(UserCtrl.class);

	// This method redirects the user to the index page of the application.
	@RequestMapping(value="/welcome", method = RequestMethod.GET)
	public String index() {
		log.info("Redirecting the application to the landing page.");
		return "redirect:user_list";
	}

	// This method handles the request to get the user_list from the database.
	@RequestMapping(value = "/user_list", method = RequestMethod.GET)
	public ModelAndView fetchUserList() {
		List<User> ulist = dbService.getUsrList();
		log.info("Total no. of user_records fetched from db are?= " + ulist.size());

		// Returning the result to the target jsp.
		return new ModelAndView("home", "userList", ulist);			
	}
}