package com.jcg.spring.hibernate.service;

import java.util.List;

import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.springframework.transaction.annotation.Transactional;

import com.jcg.spring.hibernate.pojo.User;

public class DbService {

	private SessionFactory sessionFactory;

	private static Logger log = Logger.getLogger(DbService.class);

	// This method initialized the session_factory object for further processing.
	public DbService(SessionFactory sessionFactory) {
		this.sessionFactory = sessionFactory;
	}

	// This method fetches the user_list from the database.
	@SuppressWarnings("unchecked")
	@Transactional
	public List<User> getUsrList() {
		List<User> user_list = null;
		log.info("Fetching the user list from the database");
		try {
			String sql_query = "from User";
			user_list = sessionFactory.getCurrentSession().createQuery(sql_query).list();						
			log.info("Total no. of users fetched from the db are?= " + user_list.size());
		} catch(Exception e) {
			log.error("An error occurred while fetching the user details from the database", e);	
		}

		return user_list;
	}
}