/*
 * Decompiled with CFR 0.152.
 */
package jcg.zheng.demo.spring;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jcg.zheng.demo.spring.entity.Account;
import jcg.zheng.demo.spring.model.User;
import jcg.zheng.demo.spring.repository.AccountRepository;
import jcg.zheng.demo.spring.service.AccountService;
import jcg.zheng.demo.spring.util.TestData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class WelcomeController {
    @Autowired
    private AccountService accountService;
    @Autowired
    private AccountRepository acctRep;
    @Value(value="${welcome.message:test}")
    private String message = "Hello World";

    @RequestMapping(value={"/"})
    public String welcome(Locale locale, Map<String, Object> model) {
        model.put("message", this.message);
        System.out.println("Home Page Requested, locale = " + locale);
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, locale);
        String formattedDate = dateFormat.format(date);
        model.put("serverTime", formattedDate);
        return "home";
    }

    @RequestMapping(value={"/loadTestData"})
    public String setup() {
        Account maryZheng = TestData.createDummy((String)"maryZheng", (String)"Mary", (String)"Zheng");
        maryZheng.addTransactions(TestData.createTransaction((String)"KOHL", (String)"Birthday gifts", (BigDecimal)new BigDecimal(300)));
        maryZheng.addTransactions(TestData.createTransaction((String)"Macy", (String)"Allen clothes", (BigDecimal)new BigDecimal(100)));
        maryZheng.addTransactions(TestData.createTransaction((String)"Home Depot", (String)"house items", (BigDecimal)new BigDecimal(1000)));
        maryZheng.addTransactions(TestData.createTransaction((String)"Wal-mart", (String)"small items", (BigDecimal)new BigDecimal(60)));
        this.acctRep.save((Object)maryZheng);
        Account demo = TestData.createDummy((String)"demo", (String)"Demo", (String)"JCG");
        demo.addTransactions(TestData.createTransaction((String)"Shop&Save", (String)"food items", (BigDecimal)new BigDecimal(60)));
        demo.addTransactions(TestData.createTransaction((String)"Webster", (String)"school supplies", (BigDecimal)new BigDecimal(260)));
        this.acctRep.save((Object)demo);
        return "home";
    }

    @RequestMapping(value={"/user"}, method={RequestMethod.POST})
    public String user(@Validated User user, Model model) {
        System.out.println("User Page Requested");
        model.addAttribute("userName", (Object)user.getUserName());
        Account foundUser = this.accountService.findByUsername(user.getUserName());
        if (foundUser != null) {
            model.addAttribute("account", (Object)foundUser);
            return "user";
        }
        return "invalidUser";
    }

    @ExceptionHandler(value={Exception.class})
    public String exceptionHandler(HttpServletRequest request, Exception ex, Model model) {
        model.addAttribute("content", (Object)request.getRequestURL());
        model.addAttribute("error", (Object)ex.getMessage());
        return "error";
    }
}

