package com.spring.mvc.model.attribute;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ModelController {

	@ModelAttribute(name= "countrieslist")
	public List<String> populateCountries() {

		List<String> countries= new ArrayList<String>();
		countries.add("India");
		countries.add("United States");
		countries.add("Japan");
		countries.add("Australia");
		countries.add("Canda");		

		return countries;
	}

	@RequestMapping(value= "/init", method= RequestMethod.GET)
	public ModelAndView initView(@ModelAttribute(name= "countrieslist") List<String> countries) {

		ModelAndView modelview = new ModelAndView();
		modelview.addObject("message", "This is an example of using the @ModelAttribute annotation .....!");
		modelview.setViewName("output");

		return modelview;
	}
}