package com.javacodegeeks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ArrayToList {

    public static void main(String[] args) {
        int[] primitiveArr = new int[]{1,2, 10, 6, 788, 32};

        // Before Java 8
        List<Integer> list = new ArrayList(primitiveArr.length);
        for(int i : primitiveArr) {
            list.add(Integer.valueOf(i));
        }

        System.out.println("Before Java8 > " + list);

        List<Integer> listUsingJava8 = Arrays.stream(primitiveArr).boxed().collect(Collectors.toList());
        System.out.println("Java8 > " + listUsingJava8);

        List<Integer> listUsingIntStream = IntStream.of(primitiveArr).boxed().collect(Collectors.toList());
        System.out.println("IntStream > " + listUsingIntStream);

        Integer[] boxedArray = Arrays.stream(primitiveArr).boxed().toArray(Integer[]::new);
        List<Integer> list2 = new ArrayList();
        Collections.addAll(list2, boxedArray);
        System.out.println("Another way > " + list2);
    }
}
