/*
 * Decompiled with CFR 0.152.
 */
package jcg.zheng.demo.spring.controller;

import jcg.zheng.demo.spring.entity.Account;
import jcg.zheng.demo.spring.model.User;
import jcg.zheng.demo.spring.service.AccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class UserController {
    private static final String NEWUSER_VIEW = "newuser";
    private static final String USER_VIEW = "user";
    @Autowired
    private AccountService accountService;

    @RequestMapping(value={"/user/save"}, method={RequestMethod.POST})
    public String saveuser(@Validated @ModelAttribute(value="account") Account acct, Model model) {
        this.accountService.save(acct);
        model.addAttribute("account", (Object)acct);
        return USER_VIEW;
    }

    @RequestMapping(value={"/user"}, method={RequestMethod.POST})
    public String user(@Validated User user, Model model) {
        model.addAttribute("userName", (Object)user.getUserName());
        Account foundUser = this.accountService.findByUsername(user.getUserName());
        if (foundUser != null) {
            model.addAttribute("account", (Object)foundUser);
            return USER_VIEW;
        }
        return NEWUSER_VIEW;
    }
}

