package com.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

public class StringToCharArrayTest {

	private StringToCharArray sv = new StringToCharArray("Test");

	@Test
	public void via_toCharArray() {
		char[] chars = sv.toCharArray();
		assertTrue('T'== chars[0]);
		assertTrue('e'== chars[1]);
		assertTrue('s'== chars[2]);
		assertTrue('t'== chars[3]);
	}
	
	@Test
	public void  via_charat_2() {
		char[] chars = sv.toCharsBycharat2();
		assertTrue('T'== chars[0]);
		assertTrue('e'== chars[1]);
		assertTrue('s'== chars[2]);
		assertTrue('t'== chars[3]);
	}
	
	
	@Test
	public void  via_charat() {
		Character[] chars = sv.toCharsBycharat();
		assertEquals(new Character('T'), chars[0]);
		assertEquals(new Character('e'), chars[1]);
		assertEquals(new Character('s'), chars[2]);
		assertEquals(new Character('t'), chars[3]);
	}


}