class Juice {

    private int water;
    private int fruit;
    private int sugar;
    private int icecube;
    private String juicename;

    public int getWater() {
        return water;
    }

    public void setWater(int water) {
        this.water = water;
    }

    public int getFruit() {
        return fruit;
    }

    public void setFruit(int fruit) {
        this.fruit = fruit;
    }

    public int getSugar() {
        return sugar;
    }

    public void setSugar(int sugar) {
        this.sugar = sugar;
    }

    public int getIceCube() {
        return icecube;
    }

    public void setIceCube(int icecube) {
        this.icecube= icecube;
    }

    public String getJuiceName() {
        return juicename;
    }

    public void setJuiceName(String juicename) {
        this.juicename= juicename;
    }

    public String toString() {
        return "Cold" + juicename + " Juice  [" + water + " ml of water, " + fruit + "as a fruit, " + sugar +
            " gm of sugar, " + icecube + " no. of ice cubes]\n";
    }

}

abstract class JuiceMaker {

    private Juice juice;

    public Juice getJuice() {
        return juice;
    }

    public void setJuice(Juice juice) {
        this.juice = juice;
    }

    public final Juice makeJuice() {
        Juice juice = createJuice();
        setJuice(juice);
        setJuiceType();
        setWater();
        setFruit();
        setSugar();
        setIceCube();
        return juice;
    }

    abstract void setJuiceType();

    abstract void setWater();

    abstract void setFruit();

    abstract void setSugar();

    abstract void setIceCube();

    abstract Juice createJuice();

}

class OrangeJuice extends JuiceMaker {
    Juice createJuice() {
        return new Juice();
    }

    public void setWater() {
        System.out.println("Step 1 : Adding water into the juicer");
        getJuice().setWater(40);
    }

    public void setFruit() {
        System.out.println("Step 2 : Adding fruit into the juicer");
        getJuice().setFruit(4);
    }

    void setSugar() {
        System.out.println("Step 3 : Adding sugar into the juicer");
        getJuice().setSugar(10);
    }

    void setIceCube() {
        System.out.println("Step 4 : Adding 5 to 6 numbers of ice cubes into the juicer");
        getJuice().setIceCube(6);
    }

    void setJuiceType() {
        System.out.println("orange");
        getJuice().setJuiceName("orange");
    }

}

class AppleJuice extends JuiceMaker {
    Juice createJuice() {
        return new Juice();
    }

    public void setWater() {
        System.out.println("Step 1 : Adding water into the juicer");
        getJuice().setWater(50);
    }

    public void setFruit() {
        System.out.println("Step 2 : Adding fruit into the juicer");
        getJuice().setFruit(6);
    }

    void setSugar() {
        System.out.println("Step 3 : Adding sugar into the juicer");
        getJuice().setSugar(20);
    }

    void setIceCube() {
        System.out.println("Step 4 : Adding 7 to 8 numbers of ice cubes into the juicer");
        getJuice().setIceCube(8);
    }

    void setJuiceType() {
        System.out.println("apple");
        getJuice().setJuiceName("apple");
    }

	@Override
	void setJuiceName() {
		// TODO Auto-generated method stub
		
	}

}

class ShopKeeper {

    public static Juice takeOrder(String juiceType) {

        JuiceMaker juiceMaker = null;

        if (juiceType.equalsIgnoreCase("orange")) {
            juiceMaker = new OrangeJuice();
        } else if (juiceType.equalsIgnoreCase("apple")) {
            juiceMaker = new AppleJuice();
        } else {
            System.out.println("Sorry we don't take order for  " + juiceType);
        }
        return juiceMaker.makeJuice();
    }

}


public class BuilderDesignPattern {
	public static void main(String[] args) {

        Juice orange = ShopKeeper.takeOrder("orange");
        System.out.println(orange);

        Juice apple = ShopKeeper.takeOrder("apple");
        System.out.println(apple);
    }
}
