package com.spring.mvc;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class Myctrl {

	// Method with multiple arguments appended in the url.
	@RequestMapping(value = "/newemployee/{id}/{email}", method= RequestMethod.GET)
	public ModelAndView addEmployee(@PathVariable("id") String id, @PathVariable("email") String email) {

		ModelAndView m = new ModelAndView();
		m.addObject("msg", "Employee Id: " + id + " <=======>  Email:  " + email);
		m.setViewName("success");
		return m;
	}

	// Method with multiple arguments and handling the @pathvariable dot truncation.
	@RequestMapping(value = "/newemployee2/{id}/{email:.+}", method= RequestMethod.GET)
	public ModelAndView addEmployee2(@PathVariable("id") String id, @PathVariable("email") String email) {

		ModelAndView m = new ModelAndView();
		m.addObject("msg", "Employee Id: " + id + " <=======>  Email:  " + email);
		m.setViewName("success");
		return m;
	}
}