abstract class PrepareHouse {

 // Template method is final so subclasses can't override
 public final void constructHouse() {
  constructFoundation();
  constructPillars();
  constructWalls();
  constructWindows();
  System.out.println("House is constructed.");
 }

 // Methods to be implemented by subclasses

 public abstract void constructFoundation();

 public abstract void constructPillars();

 public abstract void constructWalls();

 public abstract void constructWindows();

}

class House extends PrepareHouse {

	 @Override
	 public void constructFoundation() {
	  System.out.println("Constructing Foundation with cement,iron rods and sand");
	 }

	 @Override
	 public void constructPillars() {
	  System.out.println("Constructing Pillars for house");
	 }

	 @Override
	 public void constructWalls() {
	  System.out.println("Constructing Walls for house");
	 }

	 @Override
	 public void constructWindows() {
	  System.out.println("Constructing Windows for house");

	 }

	}

class Flat extends PrepareHouse {

	 @Override
	 public void constructFoundation() {
	  System.out.println("Constructing Foundation with cement,iron rods and sand");
	 }

	 @Override
	 public void constructPillars() {
	  System.out.println("Constructing Pillars for flat");
	 }

	 @Override
	 public void constructWalls() {
	  System.out.println("Constructing Walls for flat");
	 }

	 @Override
	 public void constructWindows() {
	  System.out.println("Constructing Windows for flat");

	 }

	}

class Tenament extends PrepareHouse {

	 @Override
	 public void constructFoundation() {
	  System.out.println("Constructing Foundation with cement,iron rods and sand");
	 }

	 @Override
	 public void constructPillars() {
	  System.out.println("Constructing Pillars for tenament");
	 }

	 @Override
	 public void constructWalls() {
	  System.out.println("Constructing Walls for tenament");
	 }

	 @Override
	 public void constructWindows() {
	  System.out.println("Constructing Windows for tenament");

	 }

	}
public class TemplateDesignPattern {
	public static void main(String[] args) {

		  System.out.println("Constructing a House\n");
		  PrepareHouse house = new House();
		  house.constructHouse();
		 
		  System.out.println("**********************************************");

		  System.out.println("Constructing a Flat\n");
		  house = new Flat();
		  house.constructHouse();

		  System.out.println("**********************************************");

		  System.out.println("Constructing a Tenament\n");
		  house = new Tenament();
		  house.constructHouse();
		 }
}
